/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.connect.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;

public class State
implements Serializable {
    private List<Map<String, String>> taskConfigs;
    private final Map<Map<String, ?>, Map<String, ?>> partitionsToOffset;

    State() {
        this.partitionsToOffset = new ConcurrentHashMap();
    }

    State(Map<Map<String, ?>, Map<String, ?>> partitionsToOffset) {
        this.partitionsToOffset = new ConcurrentHashMap(partitionsToOffset);
    }

    public void setTaskConfigs(List<Map<String, String>> taskConfigs) {
        this.taskConfigs = taskConfigs;
    }

    public Map<String, String> getTaskConfig(int order) {
        if (order < this.taskConfigs.size()) {
            return this.taskConfigs.get(order);
        }
        return null;
    }

    void commitRecord(SourceRecord rec) {
        this.partitionsToOffset.put(rec.sourcePartition(), rec.sourceOffset());
    }

    void load(State state) {
        this.partitionsToOffset.putAll(state.partitionsToOffset);
    }

    Map<String, ?> getOffset(Map<String, ?> partition) {
        return this.partitionsToOffset.get(partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return Objects.equals(this.taskConfigs, state.taskConfigs) && Objects.equals(this.partitionsToOffset, state.partitionsToOffset);
    }

    public int hashCode() {
        return Objects.hash(this.taskConfigs, this.partitionsToOffset);
    }

    public String toString() {
        return "State{taskConfigs names=" + this.extractNames(this.taskConfigs) + ", partitionsToOffset=" + this.partitionsToOffset + "}";
    }

    private String extractNames(List<Map<String, String>> taskConfigs) {
        if (taskConfigs == null) {
            return "null";
        }
        return taskConfigs.stream().map(c -> c.getOrDefault("name", "<unnamed>")).collect(Collectors.joining(",", "[", "]"));
    }
}

