/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.kafka.impl.StreamKafkaP;
import com.hazelcast.jet.kafka.impl.WriteKafkaP;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaProcessors {
    private static final int PREFERRED_LOCAL_PARALLELISM = 4;

    private KafkaProcessors() {
    }

    public static <K, V, T> ProcessorMetaSupplier streamKafkaP(@Nonnull Properties properties, @Nonnull FunctionEx<? super ConsumerRecord<K, V>, ? extends T> projectionFn, @Nonnull EventTimePolicy<? super T> eventTimePolicy, String ... topics) {
        Preconditions.checkPositive((double)topics.length, (String)"At least one topic must be supplied");
        return ProcessorMetaSupplier.of((int)4, StreamKafkaP.processorSupplier(properties, Arrays.asList(topics), projectionFn, eventTimePolicy));
    }

    public static <T, K, V> ProcessorMetaSupplier writeKafkaP(@Nonnull Properties properties, @Nonnull String topic, @Nonnull FunctionEx<? super T, ? extends K> extractKeyFn, @Nonnull FunctionEx<? super T, ? extends V> extractValueFn, boolean exactlyOnce) {
        return KafkaProcessors.writeKafkaP(properties, (FunctionEx & Serializable)t -> new ProducerRecord(topic, extractKeyFn.apply(t), extractValueFn.apply(t)), exactlyOnce);
    }

    public static <T, K, V> ProcessorMetaSupplier writeKafkaP(@Nonnull Properties properties, @Nonnull FunctionEx<? super T, ? extends ProducerRecord<K, V>> toRecordFn, boolean exactlyOnce) {
        return ProcessorMetaSupplier.of((int)1, WriteKafkaP.supplier(properties, toRecordFn, exactlyOnce));
    }
}

