/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.kafka.KafkaProcessors;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaSinks {
    private KafkaSinks() {
    }

    @Nonnull
    public static <E, K, V> Sink<E> kafka(@Nonnull Properties properties, @Nonnull FunctionEx<? super E, ProducerRecord<K, V>> toRecordFn) {
        return Sinks.fromProcessor((String)"kafkaSink", (ProcessorMetaSupplier)KafkaProcessors.writeKafkaP(properties, toRecordFn, true));
    }

    @Nonnull
    public static <E, K, V> Sink<E> kafka(@Nonnull Properties properties, @Nonnull String topic, @Nonnull FunctionEx<? super E, K> extractKeyFn, @Nonnull FunctionEx<? super E, V> extractValueFn) {
        return Sinks.fromProcessor((String)("kafkaSink(" + topic + ")"), (ProcessorMetaSupplier)KafkaProcessors.writeKafkaP(properties, topic, extractKeyFn, extractValueFn, true));
    }

    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> kafka(@Nonnull Properties properties, @Nonnull String topic) {
        return KafkaSinks.kafka(properties, topic, Map.Entry::getKey, Map.Entry::getValue);
    }

    @Nonnull
    public static <E> Builder<E> kafka(@Nonnull Properties properties) {
        return new Builder(properties);
    }

    public static final class Builder<E> {
        private final Properties properties;
        private FunctionEx<? super E, ? extends ProducerRecord<Object, Object>> toRecordFn;
        private String topic;
        private FunctionEx<? super E, ?> extractKeyFn;
        private FunctionEx<? super E, ?> extractValueFn;
        private boolean exactlyOnce = true;

        private Builder(Properties properties) {
            this.properties = properties;
        }

        @Nonnull
        public Builder<E> topic(String topic) {
            if (this.toRecordFn != null) {
                throw new IllegalArgumentException("toRecordFn already set, you can't use topic if it's set");
            }
            this.topic = topic;
            return this;
        }

        @Nonnull
        public Builder<E> extractKeyFn(@Nonnull FunctionEx<? super E, ?> extractKeyFn) {
            if (this.toRecordFn != null) {
                throw new IllegalArgumentException("toRecordFn already set, you can't use extractKeyFn if it's set");
            }
            this.extractKeyFn = extractKeyFn;
            return this;
        }

        @Nonnull
        public Builder<E> extractValueFn(@Nonnull FunctionEx<? super E, ?> extractValueFn) {
            if (this.toRecordFn != null) {
                throw new IllegalArgumentException("toRecordFn already set, you can't use extractValueFn if it's set");
            }
            this.extractValueFn = extractValueFn;
            return this;
        }

        @Nonnull
        public Builder<E> toRecordFn(@Nullable FunctionEx<? super E, ? extends ProducerRecord<?, ?>> toRecordFn) {
            if (this.topic != null || this.extractKeyFn != null || this.extractValueFn != null) {
                throw new IllegalArgumentException("topic, extractKeyFn or extractValueFn are already set, you can't use toRecordFn along with them");
            }
            this.toRecordFn = toRecordFn;
            return this;
        }

        @Nonnull
        public Builder<E> exactlyOnce(boolean enable) {
            this.exactlyOnce = enable;
            return this;
        }

        @Nonnull
        public Sink<E> build() {
            if ((this.extractValueFn != null || this.extractKeyFn != null) && this.topic == null) {
                throw new IllegalArgumentException("if `extractKeyFn` or `extractValueFn` are set, `topic` must be set too");
            }
            if (this.topic == null && this.toRecordFn == null) {
                throw new IllegalArgumentException("either `topic` or `toRecordFn` must be set");
            }
            if (this.topic != null) {
                FunctionEx<? super E, ?> extractKeyFn1 = this.extractKeyFn != null ? this.extractKeyFn : t -> null;
                FunctionEx<? super E, ?> extractValueFn1 = this.extractValueFn != null ? this.extractValueFn : t -> t;
                return Sinks.fromProcessor((String)("kafkaSink(" + this.topic + ")"), (ProcessorMetaSupplier)KafkaProcessors.writeKafkaP(this.properties, this.topic, extractKeyFn1, extractValueFn1, this.exactlyOnce));
            }
            ProcessorMetaSupplier metaSupplier = KafkaProcessors.writeKafkaP(this.properties, this.toRecordFn, this.exactlyOnce);
            return Sinks.fromProcessor((String)"kafkaSink", (ProcessorMetaSupplier)metaSupplier);
        }
    }
}

