/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.impl;

import com.hazelcast.internal.util.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.kafka.clients.producer.KafkaProducer;

final class ResumeTransactionUtil {
    private ResumeTransactionUtil() {
    }

    static void resumeTransaction(KafkaProducer producer, long producerId, short epoch, String txnId) {
        Preconditions.checkState((producerId >= 0L && epoch >= 0 ? 1 : 0) != 0, (String)("Incorrect values for producerId " + producerId + " and epoch " + epoch));
        Object transactionManager = ResumeTransactionUtil.getValue(producer, "transactionManager");
        Object nextSequence = ResumeTransactionUtil.getValue(transactionManager, "nextSequence");
        ResumeTransactionUtil.invoke(transactionManager, "transitionTo", ResumeTransactionUtil.getEnum("org.apache.kafka.clients.producer.internals.TransactionManager$State.INITIALIZING"));
        ResumeTransactionUtil.invoke(nextSequence, "clear", new Object[0]);
        Object producerIdAndEpoch = ResumeTransactionUtil.getValue(transactionManager, "producerIdAndEpoch");
        ResumeTransactionUtil.setValue(producerIdAndEpoch, "producerId", producerId);
        ResumeTransactionUtil.setValue(producerIdAndEpoch, "epoch", epoch);
        ResumeTransactionUtil.invoke(transactionManager, "transitionTo", ResumeTransactionUtil.getEnum("org.apache.kafka.clients.producer.internals.TransactionManager$State.READY"));
        ResumeTransactionUtil.invoke(transactionManager, "transitionTo", ResumeTransactionUtil.getEnum("org.apache.kafka.clients.producer.internals.TransactionManager$State.IN_TRANSACTION"));
        ResumeTransactionUtil.setValue(transactionManager, "transactionStarted", true);
    }

    static long getProducerId(KafkaProducer kafkaProducer) {
        Object transactionManager = ResumeTransactionUtil.getValue(kafkaProducer, "transactionManager");
        Object producerIdAndEpoch = ResumeTransactionUtil.getValue(transactionManager, "producerIdAndEpoch");
        return (Long)ResumeTransactionUtil.getValue(producerIdAndEpoch, "producerId");
    }

    static short getEpoch(KafkaProducer kafkaProducer) {
        Object transactionManager = ResumeTransactionUtil.getValue(kafkaProducer, "transactionManager");
        Object producerIdAndEpoch = ResumeTransactionUtil.getValue(transactionManager, "producerIdAndEpoch");
        return (Short)ResumeTransactionUtil.getValue(producerIdAndEpoch, "epoch");
    }

    private static Enum<?> getEnum(String enumFullName) {
        String[] x = enumFullName.split("\\.(?=[^\\.]+$)");
        if (x.length == 2) {
            String enumClassName = x[0];
            String enumName = x[1];
            try {
                Class<?> cl = Class.forName(enumClassName);
                return Enum.valueOf(cl, enumName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Incompatible KafkaProducer version", e);
            }
        }
        return null;
    }

    private static Object invoke(Object object, String methodName, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return ResumeTransactionUtil.invoke(object, methodName, argTypes, args);
    }

    private static Object invoke(Object object, String methodName, Class<?>[] argTypes, Object[] args) {
        try {
            Method method = object.getClass().getDeclaredMethod(methodName, argTypes);
            method.setAccessible(true);
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    private static Object getValue(Object object, String fieldName) {
        return ResumeTransactionUtil.getValue(object, object.getClass(), fieldName);
    }

    private static Object getValue(Object object, Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    private static void setValue(Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }
}

