/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka;

import com.hazelcast.jet.avro.impl.AvroSerializerHooks;
import com.hazelcast.jet.kafka.impl.AbstractHazelcastAvroSerde;
import java.util.Map;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class HazelcastKafkaAvroDeserializer
extends AbstractHazelcastAvroSerde
implements Deserializer<GenericRecord> {
    private GenericDatumReader<GenericRecord> datumReader;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.datumReader = new GenericDatumReader(this.getSchema(configs, isKey));
    }

    public GenericRecord deserialize(String topic, byte[] data) {
        try {
            return (GenericRecord)AvroSerializerHooks.deserialize(this.datumReader, (byte[])data);
        }
        catch (Exception e) {
            throw new SerializationException("Error deserializing Avro message", (Throwable)e);
        }
    }
}

