/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb;

import java.io.Serializable;
import java.util.Locale;

public enum ResourceChecks implements Serializable
{
    ON_EACH_CONNECT,
    ONCE_PER_JOB,
    ONLY_INITIAL,
    NEVER;


    public static ResourceChecks fromString(String code) {
        String codeLowerCased;
        switch (codeLowerCased = code.toLowerCase(Locale.ROOT)) {
            case "on-each-call": {
                return ONCE_PER_JOB;
            }
            case "on-each-connect": {
                return ON_EACH_CONNECT;
            }
            case "only-initial": {
                return ONLY_INITIAL;
            }
            case "never": {
                return NEVER;
            }
        }
        throw new IllegalArgumentException("Unknown value for ResourceExistenceChecks:" + codeLowerCased);
    }

    public boolean isEverPerformed() {
        return this != NEVER;
    }
}

