/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.dataconnection;

import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.connection.ClusterDescription;
import java.util.List;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;

class CloseableMongoClient
implements MongoClient {
    final MongoClient delegate;
    private final Runnable onClose;

    CloseableMongoClient(MongoClient delegate, Runnable onClose) {
        this.delegate = delegate;
        this.onClose = onClose;
    }

    MongoClient unwrap() {
        return this.delegate;
    }

    public void close() {
        this.onClose.run();
    }

    @Nonnull
    public MongoDatabase getDatabase(@Nonnull String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Nonnull
    public ClientSession startSession() {
        return this.delegate.startSession();
    }

    @Nonnull
    public ClientSession startSession(@Nonnull ClientSessionOptions options) {
        return this.delegate.startSession(options);
    }

    @Nonnull
    public MongoIterable<String> listDatabaseNames() {
        return this.delegate.listDatabaseNames();
    }

    @Nonnull
    public MongoIterable<String> listDatabaseNames(@Nonnull ClientSession clientSession) {
        return this.delegate.listDatabaseNames(clientSession);
    }

    @Nonnull
    public ListDatabasesIterable<Document> listDatabases() {
        return this.delegate.listDatabases();
    }

    @Nonnull
    public ListDatabasesIterable<Document> listDatabases(@Nonnull ClientSession clientSession) {
        return this.delegate.listDatabases(clientSession);
    }

    @Nonnull
    public <TResult> ListDatabasesIterable<TResult> listDatabases(@Nonnull Class<TResult> tResultClass) {
        return this.delegate.listDatabases(tResultClass);
    }

    @Nonnull
    public <TResult> ListDatabasesIterable<TResult> listDatabases(@Nonnull ClientSession clientSession, @Nonnull Class<TResult> tResultClass) {
        return this.delegate.listDatabases(clientSession, tResultClass);
    }

    @Nonnull
    public ChangeStreamIterable<Document> watch() {
        return this.delegate.watch();
    }

    @Nonnull
    public <TResult> ChangeStreamIterable<TResult> watch(@Nonnull Class<TResult> tResultClass) {
        return this.delegate.watch(tResultClass);
    }

    @Nonnull
    public ChangeStreamIterable<Document> watch(@Nonnull List<? extends Bson> pipeline) {
        return this.delegate.watch(pipeline);
    }

    @Nonnull
    public <TResult> ChangeStreamIterable<TResult> watch(@Nonnull List<? extends Bson> pipeline, @Nonnull Class<TResult> tResultClass) {
        return this.delegate.watch(pipeline, tResultClass);
    }

    @Nonnull
    public ChangeStreamIterable<Document> watch(@Nonnull ClientSession clientSession) {
        return this.delegate.watch(clientSession);
    }

    @Nonnull
    public <TResult> ChangeStreamIterable<TResult> watch(@Nonnull ClientSession clientSession, @Nonnull Class<TResult> tResultClass) {
        return this.delegate.watch(clientSession, tResultClass);
    }

    @Nonnull
    public ChangeStreamIterable<Document> watch(@Nonnull ClientSession clientSession, @Nonnull List<? extends Bson> pipeline) {
        return this.delegate.watch(clientSession, pipeline);
    }

    @Nonnull
    public <TResult> ChangeStreamIterable<TResult> watch(@Nonnull ClientSession clientSession, @Nonnull List<? extends Bson> pipeline, @Nonnull Class<TResult> tResultClass) {
        return this.delegate.watch(clientSession, pipeline, tResultClass);
    }

    @Nonnull
    public ClusterDescription getClusterDescription() {
        return this.delegate.getClusterDescription();
    }
}

