/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnection;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.mongodb.dataconnection.MongoDataConnection;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DbCheckingPMetaSupplier
implements ProcessorMetaSupplier {
    private final boolean shouldCheckOnEachCall;
    private ProcessorMetaSupplier standardForceOnePMS;
    private final boolean forceTotalParallelismOne;
    private final String databaseName;
    private final String collectionName;
    private final ProcessorSupplier processorSupplier;
    private final SupplierEx<? extends MongoClient> clientSupplier;
    private final DataConnectionRef dataConnectionRef;
    private final int preferredLocalParallelism;

    public DbCheckingPMetaSupplier(boolean shouldCheckOnEachCall, boolean forceTotalParallelismOne, @Nullable String databaseName, @Nullable String collectionName, @Nullable SupplierEx<? extends MongoClient> clientSupplier, @Nullable DataConnectionRef dataConnectionRef, @Nonnull ProcessorSupplier processorSupplier, int preferredLocalParallelism) {
        this.shouldCheckOnEachCall = shouldCheckOnEachCall;
        this.forceTotalParallelismOne = forceTotalParallelismOne;
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.processorSupplier = processorSupplier;
        this.clientSupplier = clientSupplier;
        this.dataConnectionRef = dataConnectionRef;
        this.preferredLocalParallelism = forceTotalParallelismOne ? 1 : preferredLocalParallelism;
    }

    public int preferredLocalParallelism() {
        return this.preferredLocalParallelism;
    }

    public boolean initIsCooperative() {
        return !this.shouldCheckOnEachCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        if (this.forceTotalParallelismOne) {
            Address address = context.hazelcastInstance().getCluster().getLocalMember().getAddress();
            this.standardForceOnePMS = ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)this.processorSupplier, (Address)address);
            this.standardForceOnePMS.init(context);
        }
        if (this.shouldCheckOnEachCall) {
            Tuple2<MongoClient, DataConnection> clientAndRef = this.connect(context);
            try (MongoClient client = (MongoClient)clientAndRef.requiredF0();){
                if (this.databaseName != null) {
                    MongoUtilities.checkDatabaseExists(client, this.databaseName);
                    MongoDatabase database = client.getDatabase(this.databaseName);
                    if (this.collectionName != null) {
                        MongoUtilities.checkCollectionExists(database, this.collectionName);
                    }
                }
            }
            finally {
                DataConnection connection = (DataConnection)clientAndRef.f1();
                if (connection != null) {
                    connection.release();
                }
            }
        }
    }

    private Tuple2<MongoClient, DataConnection> connect(ProcessorMetaSupplier.Context context) {
        try {
            if (this.clientSupplier != null) {
                return Tuple2.tuple2((Object)((MongoClient)this.clientSupplier.get()), null);
            }
            if (this.dataConnectionRef != null) {
                NodeEngineImpl nodeEngine = Util.getNodeEngine((HazelcastInstance)context.hazelcastInstance());
                InternalDataConnectionService dataConnectionService = nodeEngine.getDataConnectionService();
                MongoDataConnection dataConnection = (MongoDataConnection)dataConnectionService.getAndRetainDataConnection(this.dataConnectionRef.getName(), MongoDataConnection.class);
                return Tuple2.tuple2((Object)dataConnection.getClient(), (Object)((Object)dataConnection));
            }
            throw new IllegalArgumentException("Either connectionSupplier or dataConnectionRef must be provided if database and collection existence checks are requested");
        }
        catch (Exception e) {
            throw new JetException("Cannot connect to MongoDB", (Throwable)e);
        }
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        if (this.forceTotalParallelismOne) {
            return this.standardForceOnePMS.get(addresses);
        }
        return addr -> this.processorSupplier;
    }

    public boolean closeIsCooperative() {
        return true;
    }
}

