/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.impl;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;

public final class Mappers {
    private static final Mappers INSTANCE = new Mappers();
    private final CodecRegistry pojoCodecRegistry;
    private final DecoderContext decoderContext;
    private final EncoderContext encoderContext;

    private Mappers() {
        PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().automatic(true).build();
        this.pojoCodecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider})});
        this.decoderContext = DecoderContext.builder().build();
        this.encoderContext = EncoderContext.builder().build();
    }

    public static <T> T map(Document doc, Class<T> type) {
        return (T)Mappers.INSTANCE.pojoCodecRegistry.get(type).decode((BsonReader)new BsonDocumentReader(doc.toBsonDocument()), Mappers.INSTANCE.decoderContext);
    }

    @Nonnull
    public static CodecRegistry defaultCodecRegistry() {
        return Mappers.INSTANCE.pojoCodecRegistry;
    }

    @Nonnull
    public static <T> FunctionEx<Document, T> toClass(Class<T> type) {
        return (FunctionEx & Serializable)doc -> Mappers.map(doc, type);
    }

    @Nonnull
    public static <T> BiFunctionEx<ChangeStreamDocument<Document>, Long, T> streamToClass(Class<T> type) {
        return (BiFunctionEx & Serializable)(doc, ts) -> {
            assert (doc.getFullDocument() != null);
            return Mappers.map((Document)doc.getFullDocument(), type);
        };
    }

    @Nonnull
    static <I> BsonDocument toBsonDocument(I item) {
        BsonDocument document = new BsonDocument();
        Class<?> aClass = item.getClass();
        Mappers.INSTANCE.pojoCodecRegistry.get(aClass).encode((BsonWriter)new BsonDocumentWriter(document), item, Mappers.INSTANCE.encoderContext);
        return document;
    }

    @Nonnull
    public static Document bsonDocumentToDocument(@Nonnull BsonDocument bsonDocument) {
        DocumentCodec codec = new DocumentCodec();
        DecoderContext decoderContext = DecoderContext.builder().build();
        return codec.decode((BsonReader)new BsonDocumentReader(bsonDocument), decoderContext);
    }

    @Nonnull
    public static Document bsonToDocument(@Nonnull Bson bson) {
        if (bson instanceof Document) {
            return (Document)bson;
        }
        BsonDocument document = bson.toBsonDocument(BsonDocument.class, Mappers.INSTANCE.pojoCodecRegistry);
        return Mappers.bsonDocumentToDocument(document);
    }
}

