/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.impl;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.mongodb.WriteMode;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.retry.RetryStrategy;
import com.mongodb.TransactionOptions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WriteMongoParams<I>
implements Serializable {
    SupplierEx<? extends MongoClient> clientSupplier;
    DataConnectionRef dataConnectionRef;
    String databaseName;
    String collectionName;
    Class<I> documentType;
    @Nonnull
    FunctionEx<?, I> intermediateMappingFn = FunctionEx.identity();
    String documentIdentityFieldName;
    FunctionEx<I, Object> documentIdentityFn;
    @Nonnull
    ConsumerEx<ReplaceOptions> replaceOptionAdjuster = ConsumerEx.noop();
    RetryStrategy commitRetryStrategy;
    SupplierEx<TransactionOptions> transactionOptionsSup;
    FunctionEx<I, String> databaseNameSelectFn;
    FunctionEx<I, String> collectionNameSelectFn;
    @Nonnull
    WriteMode writeMode = WriteMode.REPLACE;
    FunctionEx<I, WriteModel<I>> writeModelFn;
    boolean checkExistenceOnEachConnect = true;

    @Nonnull
    public SupplierEx<? extends MongoClient> getClientSupplier() {
        return this.clientSupplier;
    }

    @Nonnull
    public WriteMongoParams<I> setClientSupplier(@Nullable SupplierEx<? extends MongoClient> clientSupplier) {
        this.clientSupplier = clientSupplier;
        return this;
    }

    @Nullable
    public DataConnectionRef getDataConnectionRef() {
        return this.dataConnectionRef;
    }

    @Nonnull
    public WriteMongoParams<I> setDataConnectionRef(@Nullable DataConnectionRef dataConnectionRef) {
        this.dataConnectionRef = dataConnectionRef;
        return this;
    }

    @Nonnull
    public WriteMongoParams<I> setDataConnectionRef(@Nullable String dataConnectionName) {
        if (dataConnectionName != null) {
            this.setDataConnectionRef(DataConnectionRef.dataConnectionRef((String)dataConnectionName));
        }
        return this;
    }

    public void checkConnectivityOptionsValid() {
        boolean hasDataConnection = this.dataConnectionRef != null;
        boolean hasClientSupplier = this.clientSupplier != null;
        Preconditions.checkState((hasDataConnection || hasClientSupplier ? 1 : 0) != 0, (String)"Client supplier or data connection ref should be provided");
        Preconditions.checkState((hasDataConnection != hasClientSupplier ? 1 : 0) != 0, (String)"Only one of two should be provided: Client supplier or data connection ref");
    }

    @Nonnull
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Nonnull
    public WriteMongoParams<I> setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Nonnull
    public WriteMongoParams<I> setCollectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    @Nonnull
    public Class<I> getDocumentType() {
        return this.documentType;
    }

    @Nonnull
    public WriteMongoParams<I> setDocumentType(@Nonnull Class<I> documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nonnull
    public <T> FunctionEx<T, I> getIntermediateMappingFn() {
        return this.intermediateMappingFn;
    }

    @Nonnull
    public <IN> WriteMongoParams<I> setIntermediateMappingFn(FunctionEx<IN, I> intermediateMappingFn) {
        this.intermediateMappingFn = intermediateMappingFn;
        return this;
    }

    @Nonnull
    public FunctionEx<I, Object> getDocumentIdentityFn() {
        return this.documentIdentityFn;
    }

    @Nonnull
    public WriteMongoParams<I> setDocumentIdentityFn(@Nonnull FunctionEx<I, Object> documentIdentityFn) {
        this.documentIdentityFn = documentIdentityFn;
        return this;
    }

    @Nonnull
    public ConsumerEx<ReplaceOptions> getReplaceOptionAdjuster() {
        return this.replaceOptionAdjuster;
    }

    @Nonnull
    public WriteMongoParams<I> setReplaceOptionAdjuster(@Nonnull ConsumerEx<ReplaceOptions> replaceOptionAdjuster) {
        Util.checkNonNullAndSerializable(replaceOptionAdjuster, (String)"replaceOptionAdjuster");
        this.replaceOptionAdjuster = replaceOptionAdjuster;
        return this;
    }

    public String getDocumentIdentityFieldName() {
        return this.documentIdentityFieldName;
    }

    @Nonnull
    public WriteMongoParams<I> setDocumentIdentityFieldName(String documentIdentityFieldName) {
        this.documentIdentityFieldName = documentIdentityFieldName;
        return this;
    }

    public RetryStrategy getCommitRetryStrategy() {
        return this.commitRetryStrategy;
    }

    @Nonnull
    public WriteMongoParams<I> setCommitRetryStrategy(RetryStrategy commitRetryStrategy) {
        this.commitRetryStrategy = commitRetryStrategy;
        return this;
    }

    public SupplierEx<TransactionOptions> getTransactionOptionsSup() {
        return this.transactionOptionsSup;
    }

    @Nonnull
    public WriteMongoParams<I> setTransactionOptionsSup(SupplierEx<TransactionOptions> transactionOptionsSup) {
        this.transactionOptionsSup = transactionOptionsSup;
        return this;
    }

    public FunctionEx<I, String> getDatabaseNameSelectFn() {
        return this.databaseNameSelectFn;
    }

    @Nonnull
    public WriteMongoParams<I> setDatabaseNameSelectFn(FunctionEx<I, String> databaseNameSelectFn) {
        Util.checkSerializable(databaseNameSelectFn, (String)"databaseNameSelectFn");
        this.databaseNameSelectFn = databaseNameSelectFn;
        return this;
    }

    public FunctionEx<I, String> getCollectionNameSelectFn() {
        return this.collectionNameSelectFn;
    }

    @Nonnull
    public WriteMongoParams<I> setCollectionNameSelectFn(FunctionEx<I, String> collectionNameSelectFn) {
        Util.checkSerializable(collectionNameSelectFn, (String)"collectionNameSelectFn");
        this.collectionNameSelectFn = collectionNameSelectFn;
        return this;
    }

    @Nonnull
    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public WriteMongoParams<I> setWriteMode(@Nonnull WriteMode writeMode) {
        Preconditions.checkNotNull((Object)((Object)writeMode), (String)"writeMode cannot be null");
        this.writeMode = writeMode;
        return this;
    }

    public FunctionEx<I, WriteModel<I>> getWriteModelFn() {
        return this.writeModelFn;
    }

    public Optional<FunctionEx<I, WriteModel<I>>> getOptionalWriteModelFn() {
        return Optional.ofNullable(this.writeModelFn);
    }

    @Nonnull
    public WriteMongoParams<I> setWriteModelFn(FunctionEx<I, WriteModel<I>> writeModelFn) {
        this.writeModelFn = writeModelFn;
        return this;
    }

    public boolean isCheckExistenceOnEachConnect() {
        return this.checkExistenceOnEachConnect;
    }

    public WriteMongoParams<I> setCheckExistenceOnEachConnect(boolean checkExistenceOnEachConnect) {
        this.checkExistenceOnEachConnect = checkExistenceOnEachConnect;
        return this;
    }

    public void checkValid() {
        this.checkConnectivityOptionsValid();
        Preconditions.checkNotNull(this.documentIdentityFn, (String)"documentIdentityFn must be set");
        Preconditions.checkNotNull((Object)this.commitRetryStrategy, (String)"commitRetryStrategy must be set");
        Preconditions.checkNotNull(this.transactionOptionsSup, (String)"transactionOptions must be set");
        Preconditions.checkState((this.databaseName == null == (this.collectionName == null) ? 1 : 0) != 0, (String)"if one of [databaseName, collectionName] is provided, so should the other one");
        Preconditions.checkState((this.databaseNameSelectFn == null == (this.collectionNameSelectFn == null) ? 1 : 0) != 0, (String)"if one of [selectDatabaseNameFn, selectCollectionNameFn] is provided, so should the other one");
        Preconditions.checkState((this.databaseNameSelectFn == null != (this.databaseName == null) ? 1 : 0) != 0, (String)"Only select*Fn or *Name functions should be called, never mixed");
    }
}

