/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.connector.mongodb.BsonTypes;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public final class ConversionsFromBson {
    public static final int OCT_RADIX = 16;

    private ConversionsFromBson() {
    }

    @Nullable
    public static Object convertFromBson(@Nullable Object toConvert, @Nonnull QueryDataType sqlType) {
        if (toConvert == null) {
            return null;
        }
        Object value = BsonTypes.unwrapSimpleWrappers(toConvert);
        if (sqlType.getTypeFamily() == QueryDataTypeFamily.JSON) {
            if (value instanceof String) {
                return new HazelcastJsonValue((String)value);
            }
            if (value instanceof Document) {
                Document doc = (Document)value;
                return new HazelcastJsonValue(doc.toJson());
            }
            if (value instanceof BsonDocument) {
                BsonDocument doc = (BsonDocument)value;
                return new HazelcastJsonValue(doc.toJson());
            }
        }
        if (value instanceof ObjectId) {
            value = ConversionsFromBson.convertObjectId((ObjectId)value, sqlType);
        } else if (toConvert instanceof BsonDateTime) {
            value = ConversionsFromBson.convertDateTime((BsonDateTime)toConvert, sqlType);
        } else if (toConvert instanceof BsonTimestamp) {
            value = ConversionsFromBson.convertTimestamp((BsonTimestamp)toConvert, sqlType);
        } else if (toConvert instanceof BsonMinKey || toConvert instanceof BsonMaxKey || toConvert instanceof MinKey || toConvert instanceof MaxKey) {
            if (sqlType.getTypeFamily() != QueryDataTypeFamily.OBJECT) {
                value = toConvert.toString();
            }
        } else if (toConvert instanceof Date) {
            value = ConversionsFromBson.convertJavaDate((Date)toConvert, sqlType);
        } else if (toConvert instanceof Document && sqlType.getTypeFamily() == QueryDataTypeFamily.VARCHAR) {
            value = ((Document)toConvert).toJson();
        } else if (toConvert instanceof BsonDocument && sqlType.getTypeFamily() == QueryDataTypeFamily.VARCHAR) {
            value = ((BsonDocument)toConvert).toJson();
        }
        return sqlType.convert(value);
    }

    private static Object convertObjectId(@Nonnull ObjectId value, QueryDataType resultType) {
        if (resultType.equals((Object)QueryDataType.VARCHAR)) {
            return value.toHexString();
        }
        if (resultType.equals((Object)QueryDataType.OBJECT)) {
            return value;
        }
        if (resultType.equals((Object)QueryDataType.DECIMAL)) {
            return new BigDecimal(new BigInteger(value.toHexString(), 16));
        }
        if (resultType.equals((Object)QueryDataType.DECIMAL_BIG_INTEGER)) {
            return new BigInteger(value.toHexString(), 16);
        }
        return null;
    }

    private static Object convertDateTime(@Nonnull BsonDateTime value, QueryDataType resultType) {
        ZonedDateTime dateTime = LocalDateTime.from(Instant.ofEpochMilli(value.getValue())).atZone(ZoneOffset.UTC);
        Object fromDateTime = ConversionsFromBson.convertGivenTime(resultType, dateTime);
        if (fromDateTime != null) {
            return fromDateTime;
        }
        if (resultType.equals((Object)QueryDataType.OBJECT)) {
            return value;
        }
        if (resultType.equals((Object)QueryDataType.INT)) {
            return value.getValue();
        }
        if (resultType.equals((Object)QueryDataType.BIGINT)) {
            return new BigDecimal(value.getValue());
        }
        return null;
    }

    private static Object convertJavaDate(Date value, QueryDataType resultType) {
        ZonedDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(value.getTime()), ZoneOffset.UTC).atZone(ZoneOffset.UTC);
        Object fromDateTime = ConversionsFromBson.convertGivenTime(resultType, dateTime);
        if (fromDateTime != null) {
            return fromDateTime;
        }
        if (resultType.equals((Object)QueryDataType.OBJECT)) {
            return value;
        }
        if (resultType.equals((Object)QueryDataType.INT)) {
            return value.getTime();
        }
        if (resultType.equals((Object)QueryDataType.BIGINT)) {
            return new BigDecimal(value.getTime());
        }
        return null;
    }

    private static Object convertTimestamp(BsonTimestamp value, QueryDataType resultType) {
        ZonedDateTime dateTime = LocalDateTime.ofEpochSecond(value.getTime(), 0, ZoneOffset.UTC).atZone(ZoneOffset.UTC);
        Object fromDateTime = ConversionsFromBson.convertGivenTime(resultType, dateTime);
        if (fromDateTime != null) {
            return fromDateTime;
        }
        if (resultType.equals((Object)QueryDataType.OBJECT)) {
            return value;
        }
        if (resultType.equals((Object)QueryDataType.INT)) {
            return value.getValue();
        }
        if (resultType.equals((Object)QueryDataType.BIGINT)) {
            return new BigDecimal(value.getValue());
        }
        return null;
    }

    private static Object convertGivenTime(QueryDataType resultType, ZonedDateTime dateTime) {
        if (resultType.equals((Object)QueryDataType.DATE)) {
            return dateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
        }
        if (resultType.equals((Object)QueryDataType.TIME)) {
            return dateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
        }
        if (resultType.equals((Object)QueryDataType.TIMESTAMP)) {
            return dateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (resultType.equals((Object)QueryDataType.TIMESTAMP_WITH_TZ_DATE)) {
            return dateTime.withZoneSameInstant(ZoneId.systemDefault());
        }
        if (resultType.equals((Object)QueryDataType.TIMESTAMP_WITH_TZ_ZONED_DATE_TIME)) {
            return dateTime.withZoneSameInstant(ZoneId.systemDefault());
        }
        if (resultType.equals((Object)QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME)) {
            return dateTime.withZoneSameInstant(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (resultType.equals((Object)QueryDataType.VARCHAR)) {
            return dateTime.toString();
        }
        return null;
    }
}

