/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.jet.mongodb.ResourceChecks;
import com.hazelcast.jet.mongodb.dataconnection.MongoDataConnection;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.sql.impl.connector.mongodb.BsonTypes;
import com.hazelcast.jet.sql.impl.connector.mongodb.Options;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.BsonType;
import org.bson.Document;

class FieldResolver {
    private final NodeEngine nodeEngine;

    FieldResolver(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    List<MappingField> resolveFields(@Nonnull String[] externalName, @Nullable String dataConnectionName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields, boolean stream) {
        Predicate<MappingField> pkColumnName = Options.getPkColumnChecker(options, stream);
        Map<String, DocumentField> dbFields = this.readFields(externalName, dataConnectionName, options, stream);
        ArrayList<MappingField> resolvedFields = new ArrayList<MappingField>();
        if (userFields.isEmpty()) {
            for (DocumentField documentField : dbFields.values()) {
                MappingField mappingField = new MappingField(documentField.columnName, this.resolveType(documentField.columnType), documentField.columnName, documentField.columnType.name());
                mappingField.setPrimaryKey(pkColumnName.test(mappingField));
                resolvedFields.add(mappingField);
            }
        } else {
            for (MappingField f : userFields) {
                String prefixIfStream = stream ? "fullDocument." : "";
                String nameInMongo = f.externalName() == null ? prefixIfStream + f.name() : f.externalName();
                DocumentField documentField = this.getField(dbFields, f, stream);
                if (documentField == null) {
                    throw new IllegalArgumentException("Could not resolve field with name " + nameInMongo);
                }
                MappingField mappingField = new MappingField(f.name(), f.type(), documentField.columnName, documentField.columnType.name());
                mappingField.setPrimaryKey(pkColumnName.test(mappingField));
                this.validateType(f, documentField);
                resolvedFields.add(mappingField);
            }
        }
        return resolvedFields;
    }

    private DocumentField getField(Map<String, DocumentField> dbFields, MappingField f, boolean stream) {
        String externalName;
        String string = externalName = f.externalName() == null ? f.name() : f.externalName();
        if (stream) {
            String withPrefix = "fullDocument." + externalName;
            if (dbFields.containsKey(withPrefix)) {
                return dbFields.get(withPrefix);
            }
            return dbFields.get(externalName);
        }
        return dbFields.get(externalName);
    }

    boolean isId(String nameInMongo, boolean stream) {
        if (stream) {
            return "fullDocument._id".equalsIgnoreCase(nameInMongo);
        }
        return "_id".equalsIgnoreCase(nameInMongo);
    }

    private QueryDataType resolveType(BsonType columnType) {
        switch (columnType) {
            case INT32: {
                return QueryDataType.INT;
            }
            case INT64: {
                return QueryDataType.BIGINT;
            }
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
            case BOOLEAN: {
                return QueryDataType.BOOLEAN;
            }
            case TIMESTAMP: 
            case DATE_TIME: {
                return QueryDataType.TIMESTAMP;
            }
            case STRING: 
            case JAVASCRIPT: 
            case JAVASCRIPT_WITH_SCOPE: {
                return QueryDataType.VARCHAR;
            }
            case DECIMAL128: {
                return QueryDataType.DECIMAL;
            }
            case OBJECT_ID: 
            case BINARY: 
            case MIN_KEY: 
            case ARRAY: 
            case REGULAR_EXPRESSION: 
            case MAX_KEY: {
                return QueryDataType.OBJECT;
            }
            case DOCUMENT: {
                return QueryDataType.JSON;
            }
        }
        throw QueryException.error((String)("BSON type " + columnType + " is not yet supported"));
    }

    private void validateType(MappingField field, DocumentField documentField) {
        QueryDataType type = this.resolveType(documentField.columnType);
        if (!field.type().equals((Object)type) && !type.getConverter().canConvertTo(field.type().getTypeFamily())) {
            throw new IllegalStateException("Type " + field.type().getTypeFamily() + " of field " + field.name() + " does not match db type " + type.getTypeFamily());
        }
    }

    Map<String, DocumentField> readFields(String[] externalNames, String dataConnectionName, Map<String, String> options, boolean stream) {
        String collectionName = externalNames.length == 2 ? externalNames[1] : externalNames[0];
        String databaseName = Options.getDatabaseName(this.nodeEngine, externalNames, dataConnectionName);
        LinkedHashMap<String, DocumentField> fields = new LinkedHashMap<String, DocumentField>();
        try (MongoClient client = this.connect(dataConnectionName, options);){
            MongoDatabase database;
            List collections;
            Objects.requireNonNull(client);
            ResourceChecks resourceChecks = Options.readExistenceChecksFlag(options);
            if (resourceChecks.isEverPerformed()) {
                MongoUtilities.checkDatabaseAndCollectionExists(client, databaseName, collectionName);
            }
            if ((collections = (List)(database = client.getDatabase(databaseName)).listCollections().filter(Filters.eq((String)"name", (Object)collectionName)).into(new ArrayList())).isEmpty()) {
                ArrayList list = (ArrayList)database.listCollectionNames().into(new ArrayList());
                throw new IllegalArgumentException("collection " + collectionName + " was not found, maybe you mean: " + list);
            }
            Document collectionInfo = (Document)collections.get(0);
            Document properties = this.getIgnoringNulls(collectionInfo, "options", "validator", "$jsonSchema", "properties");
            if (properties != null) {
                for (Map.Entry property : properties.entrySet()) {
                    Document props = (Document)property.getValue();
                    BsonType bsonType = BsonTypes.getBsonType(props);
                    Object key = (String)property.getKey();
                    if (stream) {
                        key = "fullDocument." + (String)key;
                    }
                    fields.put((String)key, new DocumentField(bsonType, (String)key));
                }
            } else {
                ArrayList samples = (ArrayList)database.getCollection(collectionName).find().limit(1).into(new ArrayList());
                if (samples.isEmpty()) {
                    throw new IllegalStateException("Cannot infer schema of collection " + collectionName + ", no documents found");
                }
                Document sample = (Document)samples.get(0);
                for (Map.Entry entry : sample.entrySet()) {
                    if (entry.getValue() == null) continue;
                    Object key = (String)entry.getKey();
                    if (stream) {
                        key = "fullDocument." + (String)key;
                    }
                    DocumentField field = new DocumentField(BsonTypes.resolveTypeFromJava(entry.getValue()), (String)key);
                    fields.put((String)key, field);
                }
            }
            if (stream) {
                fields.put("operationType", new DocumentField(BsonType.STRING, "operationType"));
                fields.put("resumeToken", new DocumentField(BsonType.STRING, "resumeToken"));
                fields.put("wallTime", new DocumentField(BsonType.DATE_TIME, "wallTime"));
                fields.put("ts", new DocumentField(BsonType.TIMESTAMP, "ts"));
                fields.put("clusterTime", new DocumentField(BsonType.TIMESTAMP, "clusterTime"));
            }
        }
        return fields;
    }

    private Document getIgnoringNulls(@Nonnull Document doc, String ... options) {
        Document returned = doc;
        for (String option : options) {
            Object o = returned.get((Object)option);
            if (o == null) {
                return null;
            }
            returned = (Document)o;
        }
        return returned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoClient connect(String dataConnectionName, Map<String, String> options) {
        if (dataConnectionName != null) {
            MongoDataConnection link = (MongoDataConnection)this.nodeEngine.getDataConnectionService().getAndRetainDataConnection(dataConnectionName, MongoDataConnection.class);
            try {
                MongoClient mongoClient = link.getClient();
                return mongoClient;
            }
            finally {
                link.release();
            }
        }
        String connectionString = Objects.requireNonNull(options.get("connectionString"), "Cannot connect to MongoDB, connectionString was not provided");
        return MongoClients.create((String)connectionString);
    }

    @VisibleForTesting
    static class DocumentField {
        final String columnName;
        final BsonType columnType;

        DocumentField(BsonType columnType, String columnName) {
            this.columnType = Objects.requireNonNull(columnType);
            this.columnName = Objects.requireNonNull(columnName);
        }

        public String toString() {
            return "MongoField{columnName='" + this.columnName + "', typeName='" + this.columnType + "'}";
        }
    }
}

