/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.mongodb.MongoSinkBuilder;
import com.hazelcast.jet.mongodb.WriteMode;
import com.hazelcast.jet.mongodb.impl.WriteMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.hazelcast.jet.sql.impl.connector.mongodb.ConversionsToBson;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.mongodb.TransactionOptions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bson.BsonType;
import org.bson.Document;

public class InsertProcessorSupplier
extends MongoProcessorSupplier
implements DataSerializable {
    private WriteMode writeMode;
    private QueryDataType[] types;
    private BsonType[] externalTypes;
    private String idField;

    public InsertProcessorSupplier() {
    }

    InsertProcessorSupplier(MongoTable table, WriteMode writeMode) {
        super(table);
        this.types = table.fieldTypes();
        this.externalTypes = table.externalTypes();
        this.writeMode = writeMode;
        this.idField = table.primaryKeyExternalName();
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        if (this.connectionString != null) {
            this.clientSupplier = (SupplierEx & Serializable)() -> MongoClients.create((String)this.connectionString);
        }
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Processor[] processors = new Processor[count];
        String idFieldName = this.idField;
        for (int i = 0; i < count; ++i) {
            WriteMongoP processor = new WriteMongoP(new WriteMongoParams().setClientSupplier((SupplierEx<MongoClient>)this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Document.class).setDocumentIdentityFn((FunctionEx<Document, Object>)(FunctionEx & Serializable)doc -> doc.get((Object)idFieldName)).setDocumentIdentityFieldName(idFieldName).setCommitRetryStrategy(MongoSinkBuilder.DEFAULT_COMMIT_RETRY_STRATEGY).setTransactionOptionsSup((SupplierEx<TransactionOptions>)(SupplierEx & Serializable)() -> MongoSinkBuilder.DEFAULT_TRANSACTION_OPTION).setIntermediateMappingFn(this::rowToDoc).setCheckExistenceOnEachConnect(this.checkExistenceOnEachConnect).setWriteMode(this.writeMode));
            processors[i] = processor;
        }
        return Arrays.asList(processors);
    }

    private Document rowToDoc(JetSqlRow row) {
        Object[] values = row.getValues();
        Document doc = new Document();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            String fieldName = this.externalNames[i];
            Object value = values[i];
            if (fieldName.equals("_id") && value == null) continue;
            value = ConversionsToBson.convertToBson(value, this.types[i], this.externalTypes[i]);
            doc = doc.append(fieldName, value);
        }
        return doc;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.connectionString);
        out.writeString(this.databaseName);
        out.writeString(this.collectionName);
        out.writeStringArray(this.externalNames);
        out.writeString(this.writeMode == null ? null : this.writeMode.name());
        out.writeObject((Object)this.types);
        out.writeInt(this.externalTypes == null ? 0 : this.externalTypes.length);
        for (BsonType externalType : this.externalTypes) {
            out.writeInt(externalType.getValue());
        }
        out.writeString(this.dataConnectionName);
        out.writeString(this.idField);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.connectionString = in.readString();
        this.databaseName = in.readString();
        this.collectionName = in.readString();
        this.externalNames = in.readStringArray();
        String writeModeName = in.readString();
        this.writeMode = writeModeName == null ? null : WriteMode.valueOf(writeModeName);
        this.types = (QueryDataType[])in.readObject();
        int howManyExtTypes = in.readInt();
        BsonType[] extTypes = new BsonType[howManyExtTypes];
        for (int i = 0; i < howManyExtTypes; ++i) {
            extTypes[i] = BsonType.findByValue((int)in.readInt());
        }
        this.externalTypes = extTypes;
        this.dataConnectionName = in.readString();
        this.idField = in.readString();
    }
}

