/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.mongodb.WriteMode;
import com.hazelcast.jet.mongodb.impl.Mappers;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.mongodb.DeleteProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.mongodb.InsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoSqlConnectorBase;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.jet.sql.impl.connector.mongodb.RexToMongoVisitor;
import com.hazelcast.jet.sql.impl.connector.mongodb.UpdateProcessorSupplier;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitor;
import com.mongodb.client.model.Filters;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoSqlConnector
extends MongoSqlConnectorBase {
    public static final String TYPE_NAME = "Mongo";

    public String typeName() {
        return TYPE_NAME;
    }

    @Nonnull
    public SqlConnector.VertexWithInputConfig insertProcessor(@Nonnull SqlConnector.DagBuildContext context) {
        Vertex vertex = context.getDag().newUniqueVertex("Insert(" + context.getTable().getSqlName() + ")", (ProcessorSupplier)new InsertProcessorSupplier((MongoTable)context.getTable(), WriteMode.INSERT_ONLY));
        return new SqlConnector.VertexWithInputConfig(vertex);
    }

    @Nonnull
    public Vertex updateProcessor(@Nonnull SqlConnector.DagBuildContext context, @Nonnull List<String> fieldNames, @Nonnull List<HazelcastRexNode> expressions, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        MongoTable table = (MongoTable)context.getTable();
        RexToMongoVisitor visitor = new RexToMongoVisitor();
        List updates = expressions.stream().map(e -> ((RexNode)e.unwrap(RexNode.class)).accept((RexVisitor)visitor)).map(doc -> {
            assert (doc instanceof Serializable);
            return (Serializable)doc;
        }).collect(Collectors.toList());
        String[] fieldNamesArray = (String[])fieldNames.toArray(String[]::new);
        if (hasInput) {
            return context.getDag().newUniqueVertex("Update(" + table.getSqlName() + ")", (ProcessorMetaSupplier)MongoSqlConnector.wrap(context, new UpdateProcessorSupplier(table, fieldNamesArray, updates, null, hasInput)));
        }
        Bson predicateRaw = predicate == null ? Filters.empty() : ((RexNode)predicate.unwrap(RexNode.class)).accept((RexVisitor)visitor);
        Serializable translated = predicateRaw instanceof Bson ? Mappers.bsonToDocument(predicateRaw) : (Serializable)predicateRaw;
        return context.getDag().newUniqueVertex("Update(" + table.getSqlName() + ")", (ProcessorMetaSupplier)MongoSqlConnector.wrapWithParallelismOne(context, new UpdateProcessorSupplier(table, fieldNamesArray, updates, translated, hasInput)));
    }

    @Nonnull
    public Vertex sinkProcessor(@Nonnull SqlConnector.DagBuildContext context) {
        MongoTable table = (MongoTable)context.getTable();
        return context.getDag().newUniqueVertex("Sink(" + table.getSqlName() + ")", (ProcessorMetaSupplier)MongoSqlConnector.wrap(context, new InsertProcessorSupplier(table, WriteMode.UPSERT)));
    }

    @Nonnull
    public Vertex deleteProcessor(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        Object predicateToSend;
        Document predicateTranslated;
        MongoTable table = (MongoTable)context.getTable();
        if (hasInput) {
            return context.getDag().newUniqueVertex("Delete(" + table.getSqlName() + ")", (ProcessorMetaSupplier)MongoSqlConnector.wrap(context, new DeleteProcessorSupplier(table, null, hasInput)));
        }
        Object object = predicateTranslated = predicate == null ? MongoUtilities.UPDATE_ALL_PREDICATE : ((RexNode)predicate.unwrap(RexNode.class)).accept((RexVisitor)new RexToMongoVisitor());
        if (predicateTranslated instanceof Bson) {
            predicateToSend = Mappers.bsonToDocument((Bson)predicateTranslated);
        } else {
            assert (predicateTranslated instanceof Serializable);
            predicateToSend = (Serializable)predicateTranslated;
        }
        return context.getDag().newUniqueVertex("Delete(" + table.getSqlName() + ")", (ProcessorMetaSupplier)MongoSqlConnector.wrapWithParallelismOne(context, new DeleteProcessorSupplier(table, (Serializable)predicateToSend, hasInput)));
    }
}

