/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bson.BsonType;

class MongoTableField
extends TableField {
    final String externalName;
    final BsonType externalType;
    final boolean primaryKey;

    MongoTableField(@Nonnull String name, @Nonnull QueryDataType type, @Nonnull String externalName, boolean hidden, @Nonnull String externalType, boolean primaryKey) {
        super(name, type, hidden);
        Preconditions.checkNotNull((Object)externalName, (String)"external name cannot be null");
        Preconditions.checkNotNull((Object)externalType, (String)"external type cannot be null");
        this.externalName = externalName;
        this.externalType = BsonType.valueOf((String)externalType);
        this.primaryKey = primaryKey;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public BsonType getExternalType() {
        return this.externalType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MongoTableField)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MongoTableField that = (MongoTableField)((Object)o);
        return this.primaryKey == that.primaryKey && Objects.equals(this.externalName, that.externalName) && Objects.equals(this.externalType, that.externalType);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.externalName, this.primaryKey, this.externalType);
    }
}

