/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.jet.sql.impl.connector.mongodb.DynamicParameter;
import com.hazelcast.jet.sql.impl.connector.mongodb.InputRef;
import com.hazelcast.jet.sql.impl.connector.mongodb.RexToMongo;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCorrelVariable;
import com.hazelcast.shaded.org.apache.calcite.rex.RexDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.rex.RexFieldAccess;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLocalRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexOver;
import com.hazelcast.shaded.org.apache.calcite.rex.RexPatternFieldRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexRangeRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexSubQuery;
import com.hazelcast.shaded.org.apache.calcite.rex.RexTableInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.shaded.org.apache.calcite.util.NlsString;
import com.hazelcast.sql.impl.expression.Expression;
import java.util.List;
import org.bson.conversions.Bson;

final class RexToMongoVisitor
implements RexVisitor<Object> {
    private static final Object[] EMPTY_EXPRESSION_OPERANDS = new Object[0];

    RexToMongoVisitor() {
    }

    public Object visitInputRef(RexInputRef inputRef) {
        int index = inputRef.getIndex();
        return new InputRef(index).asString();
    }

    public Expression<?> visitLocalRef(RexLocalRef localRef) {
        throw new UnsupportedOperationException();
    }

    public Object visitLiteral(RexLiteral literal) {
        Comparable value = literal.getValue();
        if (value instanceof NlsString) {
            return ((NlsString)value).getValue();
        }
        return value;
    }

    public Bson visitCall(RexCall call) {
        Object[] operands;
        List rexOperands = call.getOperands();
        if (rexOperands == null || rexOperands.isEmpty()) {
            operands = EMPTY_EXPRESSION_OPERANDS;
        } else {
            operands = new Object[rexOperands.size()];
            for (int i = 0; i < rexOperands.size(); ++i) {
                Object expressionOperand;
                operands[i] = expressionOperand = ((RexNode)rexOperands.get(i)).accept((RexVisitor)this);
            }
        }
        return RexToMongo.convertCall(call, operands);
    }

    public Expression<?> visitOver(RexOver over) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitCorrelVariable(RexCorrelVariable correlVariable) {
        throw new UnsupportedOperationException();
    }

    public Object visitDynamicParam(RexDynamicParam dynamicParam) {
        int index = dynamicParam.getIndex();
        return new DynamicParameter(index).asString();
    }

    public Expression<?> visitRangeRef(RexRangeRef rangeRef) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitFieldAccess(RexFieldAccess fieldAccess) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitSubQuery(RexSubQuery subQuery) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitTableInputRef(RexTableInputRef fieldRef) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        throw new UnsupportedOperationException();
    }
}

