/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.python;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.python.PythonServiceConfig;
import com.hazelcast.logging.ILogger;
import io.grpc.ManagedChannelBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

class PythonServiceContext {
    private static final String JET_TO_PYTHON_PREFIX = "jet_to_python_";
    private static final String MAIN_SHELL_SCRIPT = "jet_to_python_main.sh";
    private static final String PARAMS_SCRIPT = "jet_to_python_params.sh";
    private static final String INIT_SHELL_SCRIPT = "jet_to_python_init.sh";
    private static final String CLEANUP_SHELL_SCRIPT = "jet_to_python_cleanup.sh";
    private static final String USER_INIT_SHELL_SCRIPT = "init.sh";
    private static final String USER_CLEANUP_SHELL_SCRIPT = "cleanup.sh";
    private static final String PYTHON_GRPC_SCRIPT = "jet_to_python_grpc_server.py";
    private static final List<String> EXECUTABLE_SCRIPTS = Arrays.asList("jet_to_python_init.sh", "jet_to_python_main.sh", "jet_to_python_cleanup.sh");
    private static final List<String> USER_EXECUTABLE_SCRIPTS = Arrays.asList("init.sh", "cleanup.sh");
    private static final EnumSet<PosixFilePermission> WRITE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE);
    private static final Object INIT_LOCK = new Object();
    private final ILogger logger;
    private final Path runtimeBaseDir;
    private final BiFunctionEx<String, Integer, ? extends ManagedChannelBuilder<?>> channelFn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PythonServiceContext(ProcessorSupplier.Context context, PythonServiceConfig cfg) {
        this.logger = context.hazelcastInstance().getLoggingService().getLogger(this.getClass().getPackage().getName());
        this.checkIfPythonIsAvailable();
        this.channelFn = cfg.channelFn();
        try {
            long start = System.nanoTime();
            this.runtimeBaseDir = this.recreateRuntimeBaseDir(context, cfg);
            this.setupBaseDir(cfg);
            Object object = INIT_LOCK;
            synchronized (object) {
                Process initProcess = new ProcessBuilder("/bin/sh", "-c", "./jet_to_python_init.sh").directory(this.runtimeBaseDir.toFile()).redirectErrorStream(true).start();
                Thread stdoutLoggingThread = PythonServiceContext.logStdOut(this.logger, initProcess, "python-init");
                initProcess.waitFor();
                if (initProcess.exitValue() != 0) {
                    try {
                        this.performCleanup();
                    }
                    catch (Exception e) {
                        this.logger.warning("Cleanup failed with exception", (Throwable)e);
                    }
                    throw new Exception("Initialization script finished with non-zero exit code: " + initProcess.exitValue());
                }
                stdoutLoggingThread.join();
            }
            this.makeFilesReadOnly(this.runtimeBaseDir);
            context.logger().info(String.format("Initialization script took %,d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)));
        }
        catch (Exception e) {
            throw new JetException("PythonService initialization failed: " + e, (Throwable)e);
        }
    }

    private void checkIfPythonIsAvailable() {
        try {
            Process process = new ProcessBuilder("python3", "--version").redirectErrorStream(true).start();
            process.waitFor();
            try (InputStream inputStream = process.getInputStream();){
                String output = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                if (process.exitValue() != 0) {
                    this.logger.severe("python3 version check returned non-zero exit value, output: " + output);
                    throw new IllegalStateException("python3 is not available");
                }
                if (!output.startsWith("Python 3")) {
                    this.logger.severe("python3 version check returned unknown version, output: " + output);
                    throw new IllegalStateException("python3 is not available");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("python3 is not available", e);
        }
    }

    private void makeFilesReadOnly(@Nonnull Path basePath) throws IOException {
        List filesNotMarked = Util.editPermissionsRecursively((Path)basePath, perms -> perms.removeAll(WRITE_PERMISSIONS));
        if (!filesNotMarked.isEmpty()) {
            this.logger.info("Couldn't 'chmod -w' these files: " + filesNotMarked);
        }
    }

    private static void makeExecutable(@Nonnull Path path) throws IOException {
        Util.editPermissions((Path)path, perms -> perms.add(PosixFilePermission.OWNER_EXECUTE));
    }

    Path recreateRuntimeBaseDir(ProcessorSupplier.Context context, PythonServiceConfig cfg) {
        File baseDir = cfg.baseDir();
        if (baseDir != null) {
            return context.recreateAttachedDirectory(baseDir.toString()).toPath();
        }
        File handlerFile = cfg.handlerFile();
        if (handlerFile != null) {
            return context.recreateAttachedFile(handlerFile.toString()).toPath().getParent();
        }
        throw new IllegalArgumentException("PythonServiceConfig has neither baseDir nor handlerFile set");
    }

    void destroy() {
        try {
            this.performCleanup();
        }
        finally {
            IOUtil.delete((Path)this.runtimeBaseDir);
        }
    }

    ILogger logger() {
        return this.logger;
    }

    Path runtimeBaseDir() {
        return this.runtimeBaseDir;
    }

    private void setupBaseDir(PythonServiceConfig cfg) throws IOException {
        PythonServiceContext.createParamsScript(this.runtimeBaseDir.resolve(PARAMS_SCRIPT), "HANDLER_MODULE", cfg.handlerModule(), "HANDLER_FUNCTION", cfg.handlerFunction());
        for (String fname : Arrays.asList("jet_to_python_pb2.py", "jet_to_python_pb2_grpc.py", INIT_SHELL_SCRIPT, MAIN_SHELL_SCRIPT, CLEANUP_SHELL_SCRIPT, PYTHON_GRPC_SCRIPT)) {
            Path destPath = this.runtimeBaseDir.resolve(fname);
            try (InputStream in = Objects.requireNonNull(PythonServiceContext.class.getClassLoader().getResourceAsStream(fname), fname);
                 OutputStream out = Files.newOutputStream(destPath, new OpenOption[0]);){
                com.hazelcast.jet.impl.util.IOUtil.copyStream((InputStream)in, (OutputStream)out);
            }
            if (EXECUTABLE_SCRIPTS.contains(fname)) {
                PythonServiceContext.makeExecutable(destPath);
            }
            for (String userScript : USER_EXECUTABLE_SCRIPTS) {
                Path scriptPath = this.runtimeBaseDir.resolve(userScript);
                if (!Files.exists(scriptPath, new LinkOption[0])) continue;
                PythonServiceContext.makeExecutable(scriptPath);
            }
        }
    }

    private void performCleanup() {
        try {
            Path cleanupScriptPath;
            List filesNotMarked = Util.editPermissionsRecursively((Path)this.runtimeBaseDir, perms -> perms.add(PosixFilePermission.OWNER_WRITE));
            if (!filesNotMarked.isEmpty()) {
                this.logger.info("Couldn't 'chmod u+w' these files: " + filesNotMarked);
            }
            if (Files.exists(cleanupScriptPath = this.runtimeBaseDir.resolve(USER_CLEANUP_SHELL_SCRIPT), new LinkOption[0])) {
                Process cleanupProcess = new ProcessBuilder("/bin/sh", "-c", "./jet_to_python_cleanup.sh").directory(this.runtimeBaseDir.toFile()).redirectErrorStream(true).start();
                PythonServiceContext.logStdOut(this.logger, cleanupProcess, "python-cleanup-" + cleanupProcess);
                cleanupProcess.waitFor();
                if (cleanupProcess.exitValue() != 0) {
                    this.logger.warning("Cleanup script finished with non-zero exit code: " + cleanupProcess.exitValue());
                }
            }
        }
        catch (Exception e) {
            throw new JetException("PythonService cleanup failed: " + e, (Throwable)e);
        }
    }

    static Thread logStdOut(ILogger logger, Process process, String taskName) {
        Thread thread = new Thread(() -> {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    logger.fine(line);
                }
            }
            catch (IOException e) {
                logger.severe("Reading init script output failed", (Throwable)e);
            }
        }, taskName + "-logger_" + PythonServiceContext.processPid(process));
        thread.start();
        return thread;
    }

    static String processPid(Process process) {
        try {
            return String.valueOf(process.pid());
        }
        catch (Exception e) {
            return process.toString().replaceFirst("^.*pid=(\\d+).*$", "$1");
        }
    }

    private static void createParamsScript(@Nonnull Path paramsFile, String ... namesAndVals) throws IOException {
        try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(paramsFile, new OpenOption[0]));){
            String jetToPython = JET_TO_PYTHON_PREFIX.toUpperCase(Locale.ROOT);
            for (int i = 0; i < namesAndVals.length; i += 2) {
                String name = namesAndVals[i];
                String value = namesAndVals[i + 1];
                if (value == null || value.isEmpty()) continue;
                out.println(jetToPython + name + "='" + value + "'");
            }
        }
    }

    public BiFunctionEx<String, Integer, ? extends ManagedChannelBuilder<?>> channelFn() {
        return this.channelFn;
    }
}

