/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.s3;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkBuilder;
import com.hazelcast.memory.MemoryUnit;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public final class S3Sinks {
    private S3Sinks() {
    }

    @Nonnull
    public static <T> Sink<? super T> s3(@Nonnull String bucketName, @Nonnull SupplierEx<? extends S3Client> clientSupplier) {
        return S3Sinks.s3(bucketName, null, StandardCharsets.UTF_8, clientSupplier, Object::toString);
    }

    @Nonnull
    public static <T> Sink<? super T> s3(@Nonnull String bucketName, @Nullable String prefix, @Nonnull Charset charset, @Nonnull SupplierEx<? extends S3Client> clientSupplier, @Nonnull FunctionEx<? super T, String> toStringFn) {
        String charsetName = charset.name();
        return SinkBuilder.sinkBuilder((String)"s3Sink", (FunctionEx & Serializable)context -> new S3SinkContext(bucketName, prefix, charsetName, context.globalProcessorIndex(), toStringFn, clientSupplier)).receiveFn(S3SinkContext::receive).flushFn(S3SinkContext::flush).destroyFn(S3SinkContext::close).build();
    }

    static final class S3SinkContext<T> {
        static final int DEFAULT_MAXIMUM_PART_NUMBER = 10000;
        static final int MINIMUM_PART_NUMBER = 1;
        static int maximumPartNumber = 10000;
        static final int DEFAULT_MINIMUM_UPLOAD_PART_SIZE = (int)MemoryUnit.MEGABYTES.toBytes(5L);
        static final double BUFFER_SCALE = 1.2;
        private final String bucketName;
        private final String prefix;
        private final int processorIndex;
        private final S3Client s3Client;
        private final FunctionEx<? super T, String> toStringFn;
        private final Charset charset;
        private final byte[] lineSeparatorBytes;
        private final List<CompletedPart> completedParts = new ArrayList<CompletedPart>();
        private ByteBuffer buffer;
        private int partNumber = 1;
        private int fileNumber;
        private String uploadId;

        private S3SinkContext(String bucketName, @Nullable String prefix, String charsetName, int processorIndex, FunctionEx<? super T, String> toStringFn, SupplierEx<? extends S3Client> clientSupplier) {
            this.bucketName = bucketName;
            String trimmedPrefix = StringUtil.trim((String)prefix);
            this.prefix = StringUtil.isNullOrEmpty((String)trimmedPrefix) ? "" : trimmedPrefix;
            this.processorIndex = processorIndex;
            this.s3Client = (S3Client)clientSupplier.get();
            this.toStringFn = toStringFn;
            this.charset = Charset.forName(charsetName);
            this.lineSeparatorBytes = System.lineSeparator().getBytes(this.charset);
            this.checkIfBucketExists();
            this.resizeBuffer(DEFAULT_MINIMUM_UPLOAD_PART_SIZE);
        }

        private void initiateUpload() {
            CreateMultipartUploadRequest req = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(this.bucketName).key(this.key()).build();
            this.uploadId = this.s3Client.createMultipartUpload(req).uploadId();
        }

        private void checkIfBucketExists() {
            this.s3Client.getBucketLocation(b -> b.bucket(this.bucketName));
        }

        private void receive(T item) {
            byte[] bytes = ((String)this.toStringFn.apply(item)).getBytes(this.charset);
            int length = bytes.length + this.lineSeparatorBytes.length;
            if (this.buffer.remaining() < length) {
                this.flush();
                if (this.buffer.remaining() < length) {
                    this.resizeBuffer(length + this.buffer.position());
                }
            }
            this.buffer.put(bytes);
            this.buffer.put(this.lineSeparatorBytes);
        }

        private void resizeBuffer(int minimumLength) {
            assert (this.buffer == null || this.buffer.position() < minimumLength);
            int newCapacity = (int)((double)minimumLength * 1.2);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
            if (this.buffer != null) {
                this.buffer.flip();
                newBuffer.put(this.buffer);
            }
            this.buffer = newBuffer;
        }

        private void flush() {
            if (this.uploadId == null) {
                this.initiateUpload();
            }
            if (this.buffer.position() > DEFAULT_MINIMUM_UPLOAD_PART_SIZE) {
                boolean isLastPart = this.partNumber == maximumPartNumber;
                this.flushBuffer(isLastPart);
            }
        }

        private void close() {
            try {
                this.flushBuffer(true);
            }
            finally {
                this.s3Client.close();
            }
        }

        private void flushBuffer(boolean isLastPart) {
            if (this.buffer.position() > 0) {
                this.buffer.flip();
                UploadPartRequest req = (UploadPartRequest)UploadPartRequest.builder().bucket(this.bucketName).key(this.key()).uploadId(this.uploadId).partNumber(Integer.valueOf(this.partNumber)).build();
                String eTag = this.s3Client.uploadPart(req, RequestBody.fromByteBuffer((ByteBuffer)this.buffer)).eTag();
                this.completedParts.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(this.partNumber)).eTag(eTag).build());
                ++this.partNumber;
                this.buffer.clear();
            }
            if (isLastPart) {
                this.completeUpload();
            }
        }

        private void completeUpload() {
            try {
                if (this.completedParts.isEmpty()) {
                    this.abortUpload();
                } else {
                    CompleteMultipartUploadRequest req = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucketName).key(this.key()).uploadId(this.uploadId).multipartUpload(b -> b.parts(this.completedParts)).build();
                    this.s3Client.completeMultipartUpload(req);
                    this.completedParts.clear();
                    this.partNumber = 1;
                    this.uploadId = null;
                    ++this.fileNumber;
                }
            }
            catch (Exception e) {
                this.abortUpload();
                ExceptionUtil.rethrow((Throwable)e);
            }
        }

        private void abortUpload() {
            this.s3Client.abortMultipartUpload(b -> b.uploadId(this.uploadId).bucket(this.bucketName).key(this.key()));
        }

        private String key() {
            return this.prefix + this.processorIndex + (String)(this.fileNumber == 0 ? "" : "." + this.fileNumber);
        }
    }
}

