/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheMergePolicy;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.CacheSplitBrainHandlerService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.merge.entry.DefaultCacheEntryView;
import com.hazelcast.cache.impl.operation.CacheLegacyMergeOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.merge.AbstractMergeRunnable;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.merge.MergingEntry;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.util.function.BiConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class CacheMergeRunnable
extends AbstractMergeRunnable<ICacheRecordStore, MergingEntry<Data, Data>> {
    private final CacheService cacheService;
    private final CacheSplitBrainHandlerService cacheSplitBrainHandlerService;

    CacheMergeRunnable(Map<String, Collection<ICacheRecordStore>> collectedStores, Map<String, Collection<ICacheRecordStore>> collectedStoresWithLegacyPolicies, Collection<ICacheRecordStore> backupStores, CacheSplitBrainHandlerService cacheSplitBrainHandlerService, NodeEngine nodeEngine) {
        super("hz:impl:cacheService", collectedStores, collectedStoresWithLegacyPolicies, backupStores, nodeEngine);
        this.cacheService = (CacheService)nodeEngine.getService("hz:impl:cacheService");
        this.cacheSplitBrainHandlerService = cacheSplitBrainHandlerService;
    }

    @Override
    protected void consumeStore(ICacheRecordStore store, BiConsumer<Integer, MergingEntry<Data, Data>> consumer) {
        int partitionId = store.getPartitionId();
        for (Map.Entry<Data, CacheRecord> entry : store.getReadOnlyRecords().entrySet()) {
            Data key = entry.getKey();
            CacheRecord record = entry.getValue();
            Data dataValue = this.toData(record.getValue());
            consumer.accept(partitionId, MergingValueFactory.createMergingEntry(this.getSerializationService(), key, dataValue, record));
        }
    }

    @Override
    protected void consumeStoreLegacy(ICacheRecordStore recordStore, BiConsumer<Integer, Operation> consumer) {
        int partitionId = recordStore.getPartitionId();
        String name = recordStore.getName();
        CacheMergePolicy mergePolicy = (CacheMergePolicy)this.getMergePolicy(name);
        for (Map.Entry<Data, CacheRecord> entry : recordStore.getReadOnlyRecords().entrySet()) {
            Data key = entry.getKey();
            CacheRecord record = entry.getValue();
            DefaultCacheEntryView entryView = new DefaultCacheEntryView(key, this.toData(record.getValue()), record.getCreationTime(), record.getExpirationTime(), record.getLastAccessTime(), record.getAccessHit());
            consumer.accept(partitionId, new CacheLegacyMergeOperation(name, key, entryView, mergePolicy));
        }
    }

    @Override
    protected InMemoryFormat getInMemoryFormat(String dataStructureName) {
        return this.cacheSplitBrainHandlerService.getConfigs().get(dataStructureName).getInMemoryFormat();
    }

    @Override
    protected int getBatchSize(String dataStructureName) {
        return 100;
    }

    @Override
    protected Object getMergePolicy(String dataStructureName) {
        return this.cacheSplitBrainHandlerService.getMergePolicy(dataStructureName);
    }

    @Override
    protected void destroyStores(Collection<ICacheRecordStore> stores) {
        this.cacheSplitBrainHandlerService.destroyStores(stores);
    }

    @Override
    protected OperationFactory createMergeOperationFactory(String dataStructureName, SplitBrainMergePolicy mergePolicy, int[] partitions, List<MergingEntry<Data, Data>>[] entries) {
        CacheConfig cacheConfig = this.cacheService.getCacheConfig(dataStructureName);
        CacheOperationProvider operationProvider = this.cacheService.getCacheOperationProvider(dataStructureName, cacheConfig.getInMemoryFormat());
        return operationProvider.createMergeOperationFactory(dataStructureName, partitions, entries, mergePolicy);
    }
}

