/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.impl.InternalMigrationListener;
import com.hazelcast.internal.partition.operation.BaseMigrationOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.partition.MigrationEndpoint;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

abstract class BaseMigrationSourceOperation
extends BaseMigrationOperation {
    boolean returnResponse = true;

    BaseMigrationSourceOperation() {
    }

    BaseMigrationSourceOperation(MigrationInfo migrationInfo, int partitionStateVersion) {
        super(migrationInfo, partitionStateVersion);
    }

    @Override
    protected PartitionMigrationEvent getMigrationEvent() {
        return new PartitionMigrationEvent(MigrationEndpoint.SOURCE, this.migrationInfo.getPartitionId(), this.migrationInfo.getSourceCurrentReplicaIndex(), this.migrationInfo.getSourceNewReplicaIndex());
    }

    @Override
    protected InternalMigrationListener.MigrationParticipant getMigrationParticipantType() {
        return InternalMigrationListener.MigrationParticipant.SOURCE;
    }

    final void verifyMasterOnMigrationSource() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Address masterAddress = nodeEngine.getMasterAddress();
        if (!this.migrationInfo.getMaster().equals(masterAddress)) {
            throw new IllegalStateException("Migration initiator is not master node! => " + this.toString());
        }
        if (!masterAddress.equals(this.getCallerAddress())) {
            throw new IllegalStateException("Caller is not master node! => " + this.toString());
        }
    }

    final void verifySource(Address thisAddress, InternalPartition partition) {
        Address owner = partition.getOwnerOrNull();
        if (owner == null) {
            throw new RetryableHazelcastException("Cannot migrate at the moment! Owner of the partition is null => " + this.migrationInfo);
        }
        if (!thisAddress.equals(owner)) {
            throw new RetryableHazelcastException("Owner of partition is not this node! => " + this.toString());
        }
    }

    final void verifyExistingTarget(NodeEngine nodeEngine, Address destination) {
        MemberImpl target = nodeEngine.getClusterService().getMember(destination);
        if (target == null) {
            throw new TargetNotMemberException("Destination of migration could not be found! => " + this.toString());
        }
    }

    final PartitionReplicationEvent getPartitionReplicationEvent() {
        return new PartitionReplicationEvent(this.migrationInfo.getPartitionId(), this.migrationInfo.getDestinationNewReplicaIndex());
    }

    final void setFailed() {
        this.success = false;
        this.onMigrationComplete(false);
    }

    final void completeMigration(boolean result) {
        this.success = result;
        this.migrationInfo.doneProcessing();
        this.onMigrationComplete(result);
        this.sendResponse(result);
    }

    final void logThrowable(Throwable t) {
        Throwable throwableToLog = t;
        if (throwableToLog instanceof ExecutionException) {
            throwableToLog = throwableToLog.getCause() != null ? throwableToLog.getCause() : throwableToLog;
        }
        Level level = this.getLogLevel(throwableToLog);
        this.getLogger().log(level, throwableToLog.getMessage(), throwableToLog);
    }

    private Level getLogLevel(Throwable e) {
        return e instanceof MemberLeftException || e instanceof InterruptedException || !this.getNodeEngine().isRunning() ? Level.INFO : Level.WARNING;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public boolean returnsResponse() {
        return this.returnResponse;
    }

    @Override
    void executeBeforeMigrations() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        boolean ownerMigration = nodeEngine.getThisAddress().equals(this.migrationInfo.getSource());
        if (!ownerMigration) {
            return;
        }
        super.executeBeforeMigrations();
    }
}

