/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastInstanceProxy;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JetInstanceImpl;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.config.XmlJetConfigBuilder;
import com.hazelcast.map.merge.IgnoreMergingEntryMapMergePolicy;

public final class Jet {
    public static final String INTERNAL_JET_OBJECTS_PREFIX = "__jet.";

    private Jet() {
    }

    public static JetInstance newJetInstance(JetConfig config) {
        Jet.configureJetService(config);
        HazelcastInstanceImpl hazelcastInstance = ((HazelcastInstanceProxy)Hazelcast.newHazelcastInstance(config.getHazelcastConfig())).getOriginal();
        return new JetInstanceImpl(hazelcastInstance, config);
    }

    public static JetInstance newJetInstance() {
        JetConfig config = XmlJetConfigBuilder.getConfig();
        return Jet.newJetInstance(config);
    }

    public static JetInstance newJetClient() {
        ClientConfig clientConfig = XmlJetConfigBuilder.getClientConfig();
        return Jet.newJetClient(clientConfig);
    }

    public static JetInstance newJetClient(ClientConfig config) {
        return Jet.getJetClientInstance(HazelcastClient.newHazelcastClient(config));
    }

    public static void shutdownAll() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    static JetClientInstanceImpl getJetClientInstance(HazelcastInstance client) {
        return new JetClientInstanceImpl(((HazelcastClientProxy)client).client);
    }

    static void configureJetService(JetConfig jetConfig) {
        if (!(jetConfig.getHazelcastConfig().getConfigPatternMatcher() instanceof MatchingPointConfigPatternMatcher)) {
            throw new UnsupportedOperationException("Custom config pattern matcher is not supported in Jet");
        }
        jetConfig.getHazelcastConfig().getServicesConfig().addServiceConfig(new ServiceConfig().setEnabled(true).setName("hz:impl:jetService").setClassName(JetService.class.getName()).setConfigObject(jetConfig));
        jetConfig.getHazelcastConfig().addMapConfig(new MapConfig("__jet.*").setBackupCount(jetConfig.getInstanceConfig().getBackupCount()).setStatisticsEnabled(false).setMergePolicy(IgnoreMergingEntryMapMergePolicy.class.getName()));
    }
}

