/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.core.DefaultPartitionStrategy;
import com.hazelcast.jet.core.Partitioner;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;

public class Edge
implements IdentifiedDataSerializable {
    private Vertex source;
    private String sourceName;
    private int sourceOrdinal;
    private Vertex destination;
    private String destName;
    private int destOrdinal;
    private int priority;
    private boolean isDistributed;
    private Partitioner<?> partitioner;
    private RoutingPolicy routingPolicy = RoutingPolicy.UNICAST;
    private EdgeConfig config;

    protected Edge() {
    }

    protected Edge(@Nonnull Vertex source, int sourceOrdinal, Vertex destination, int destOrdinal) {
        this.source = source;
        this.sourceName = source.getName();
        this.sourceOrdinal = sourceOrdinal;
        this.destination = destination;
        this.destName = destination != null ? destination.getName() : null;
        this.destOrdinal = destOrdinal;
    }

    @Nonnull
    public static Edge between(@Nonnull Vertex source, @Nonnull Vertex destination) {
        return new Edge(source, 0, destination, 0);
    }

    @Nonnull
    public static Edge from(@Nonnull Vertex source) {
        return Edge.from(source, 0);
    }

    @Nonnull
    public static Edge from(@Nonnull Vertex source, int ordinal) {
        return new Edge(source, ordinal, null, 0);
    }

    @Nonnull
    public Edge to(@Nonnull Vertex destination) {
        this.destination = destination;
        this.destName = destination.getName();
        return this;
    }

    @Nonnull
    public Edge to(@Nonnull Vertex destination, int ordinal) {
        this.destination = destination;
        this.destName = destination.getName();
        this.destOrdinal = ordinal;
        return this;
    }

    @Nonnull
    public Vertex getSource() {
        return this.source;
    }

    public Vertex getDestination() {
        return this.destination;
    }

    @Nonnull
    public String getSourceName() {
        return this.sourceName;
    }

    public int getSourceOrdinal() {
        return this.sourceOrdinal;
    }

    public String getDestName() {
        return this.destName;
    }

    public int getDestOrdinal() {
        return this.destOrdinal;
    }

    @Nonnull
    public Edge priority(int priority) {
        if (priority == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("priority must not be Integer.MIN_VALUE (-2147483648)");
        }
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public <T> Edge partitioned(@Nonnull DistributedFunction<T, ?> extractKeyFn) {
        return this.partitioned(extractKeyFn, Partitioner.defaultPartitioner());
    }

    @Nonnull
    public <T, K> Edge partitioned(@Nonnull DistributedFunction<T, K> extractKeyFn, @Nonnull Partitioner<? super K> partitioner) {
        Util.checkSerializable(extractKeyFn, "extractKeyFn");
        Util.checkSerializable(partitioner, "partitioner");
        this.routingPolicy = RoutingPolicy.PARTITIONED;
        this.partitioner = new KeyPartitioner(extractKeyFn, partitioner);
        return this;
    }

    @Nonnull
    public Edge allToOne() {
        return this.partitioned(DistributedFunctions.wholeItem(), new Single());
    }

    @Nonnull
    public Edge broadcast() {
        this.routingPolicy = RoutingPolicy.BROADCAST;
        return this;
    }

    @Nonnull
    public Edge isolated() {
        this.routingPolicy = RoutingPolicy.ISOLATED;
        return this;
    }

    public Partitioner<?> getPartitioner() {
        return this.partitioner;
    }

    @Nonnull
    public RoutingPolicy getRoutingPolicy() {
        return this.routingPolicy;
    }

    public Edge distributed() {
        this.isDistributed = true;
        return this;
    }

    public boolean isDistributed() {
        return this.isDistributed;
    }

    public EdgeConfig getConfig() {
        return this.config;
    }

    public Edge setConfig(EdgeConfig config) {
        this.config = config;
        return this;
    }

    @Nonnull
    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.sourceOrdinal == 0 && this.destOrdinal == 0) {
            b.append("between(\"").append(this.sourceName).append("\", \"").append(this.destName).append("\")");
        } else {
            b.append("from(\"").append(this.sourceName).append('\"');
            if (this.sourceOrdinal != 0) {
                b.append(", ").append(this.sourceOrdinal);
            }
            b.append(").to(\"").append(this.destName).append('\"');
            if (this.destOrdinal != 0) {
                b.append(", ").append(this.destOrdinal);
            }
            b.append(')');
        }
        switch (this.getRoutingPolicy()) {
            case UNICAST: {
                break;
            }
            case ISOLATED: {
                b.append(".isolated()");
                break;
            }
            case PARTITIONED: {
                b.append(this.getPartitioner() instanceof Single ? ".allToOne()" : ".partitioned(?)");
                break;
            }
            case BROADCAST: {
                b.append(".broadcast()");
                break;
            }
        }
        if (this.isDistributed()) {
            b.append(".distributed()");
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Edge)) return false;
        Edge that = (Edge)obj;
        if (!this.sourceName.equals(that.sourceName)) return false;
        if (!this.destName.equals(that.destName)) return false;
        return true;
    }

    public int hashCode() {
        return 37 * this.sourceName.hashCode() + this.destName.hashCode();
    }

    void restoreSourceAndDest(Map<String, Vertex> nameToVertex) {
        this.source = nameToVertex.get(this.sourceName);
        this.destination = nameToVertex.get(this.destName);
        assert (this.source != null) : "Couldn't restore source vertex " + this.sourceName + " from map " + nameToVertex;
        assert (this.destination != null) : "Couldn't restore destination vertex " + this.destName + " from map " + nameToVertex;
    }

    @Override
    public void writeData(@Nonnull ObjectDataOutput out) throws IOException {
        out.writeUTF(this.getSourceName());
        out.writeInt(this.getSourceOrdinal());
        out.writeUTF(this.getDestName());
        out.writeInt(this.getDestOrdinal());
        out.writeInt(this.getPriority());
        out.writeBoolean(this.isDistributed());
        out.writeObject(this.getRoutingPolicy());
        CustomClassLoadedObject.write(out, this.getPartitioner());
        out.writeObject(this.getConfig());
    }

    @Override
    public void readData(@Nonnull ObjectDataInput in) throws IOException {
        this.sourceName = in.readUTF();
        this.sourceOrdinal = in.readInt();
        this.destName = in.readUTF();
        this.destOrdinal = in.readInt();
        this.priority = in.readInt();
        this.isDistributed = in.readBoolean();
        this.routingPolicy = (RoutingPolicy)in.readObject();
        this.partitioner = (Partitioner)CustomClassLoadedObject.read(in);
        this.config = (EdgeConfig)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    private static final class KeyPartitioner<T, K>
    implements Partitioner<T> {
        private static final long serialVersionUID = 1L;
        private final DistributedFunction<T, K> keyExtractor;
        private final Partitioner<? super K> partitioner;

        KeyPartitioner(@Nonnull DistributedFunction<T, K> keyExtractor, @Nonnull Partitioner<? super K> partitioner) {
            this.keyExtractor = keyExtractor;
            this.partitioner = partitioner;
        }

        @Override
        public void init(DefaultPartitionStrategy strat) {
            this.partitioner.init(strat);
        }

        @Override
        public int getPartition(T item, int partitionCount) {
            return this.partitioner.getPartition(this.keyExtractor.apply(item), partitionCount);
        }
    }

    private static class Single
    implements Partitioner<Object> {
        private static final long serialVersionUID = 1L;
        private final String key = UuidUtil.newUnsecureUuidString();
        private int partition;

        Single() {
        }

        @Override
        public void init(DefaultPartitionStrategy strat) {
            this.partition = strat.getPartition(this.key);
        }

        @Override
        public int getPartition(Object item, int partitionCount) {
            return this.partition;
        }
    }

    public static enum RoutingPolicy implements Serializable
    {
        UNICAST,
        ISOLATED,
        PARTITIONED,
        BROADCAST;

    }
}

