/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.datamodel.BagsByTag;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.datamodel.ThreeBags;
import com.hazelcast.jet.datamodel.TimestampedEntry;
import com.hazelcast.jet.datamodel.TimestampedItem;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.datamodel.TwoBags;
import com.hazelcast.jet.datamodel.WindowResult;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class DataModelSerializerHooks {
    DataModelSerializerHooks() {
    }

    private static class BagsByTagSerializer
    implements StreamSerializer<BagsByTag> {
        private BagsByTagSerializer() {
        }

        @Override
        public void write(ObjectDataOutput out, BagsByTag bbt) throws IOException {
            Set<Map.Entry<Tag<?>, Collection>> entries = bbt.entrySet();
            out.writeInt(entries.size());
            for (Map.Entry<Tag<?>, Collection> e : entries) {
                out.writeObject(e.getKey());
                out.writeObject(e.getValue());
            }
        }

        @Override
        public BagsByTag read(ObjectDataInput in) throws IOException {
            int size = in.readInt();
            BagsByTag bbt = new BagsByTag();
            for (int i = 0; i < size; ++i) {
                bbt.put((Tag)in.readObject(), (ArrayList)in.readObject());
            }
            return bbt;
        }

        @Override
        public int getTypeId() {
            return -316;
        }

        @Override
        public void destroy() {
        }
    }

    private static class ItemsByTagSerializer
    implements StreamSerializer<ItemsByTag> {
        private ItemsByTagSerializer() {
        }

        @Override
        public void write(ObjectDataOutput out, ItemsByTag ibt) throws IOException {
            Set<Map.Entry<Tag<?>, Object>> entries = ibt.entrySet();
            out.writeInt(entries.size());
            for (Map.Entry<Tag<?>, Object> e : entries) {
                out.writeObject(e.getKey());
                Object val = e.getValue();
                out.writeObject(val != ItemsByTag.NONE ? val : null);
            }
        }

        @Override
        public ItemsByTag read(ObjectDataInput in) throws IOException {
            int size = in.readInt();
            ItemsByTag ibt = new ItemsByTag();
            for (int i = 0; i < size; ++i) {
                ibt.put((Tag)in.readObject(), in.readObject());
            }
            return ibt;
        }

        @Override
        public int getTypeId() {
            return -315;
        }

        @Override
        public void destroy() {
        }
    }

    public static final class BagsByTagHook
    implements SerializerHook<BagsByTag> {
        @Override
        public Class<BagsByTag> getSerializationType() {
            return BagsByTag.class;
        }

        @Override
        public Serializer createSerializer() {
            return new BagsByTagSerializer();
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class ItemsByTagHook
    implements SerializerHook<ItemsByTag> {
        @Override
        public Class<ItemsByTag> getSerializationType() {
            return ItemsByTag.class;
        }

        @Override
        public Serializer createSerializer() {
            return new ItemsByTagSerializer();
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class TagHook
    implements SerializerHook<Tag> {
        @Override
        public Class<Tag> getSerializationType() {
            return Tag.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<Tag>(){

                @Override
                public void write(ObjectDataOutput out, Tag tag) throws IOException {
                    out.writeInt(tag.index());
                }

                @Override
                public Tag read(ObjectDataInput in) throws IOException {
                    return Tag.tag(in.readInt());
                }

                @Override
                public int getTypeId() {
                    return -314;
                }

                @Override
                public void destroy() {
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class ThreeBagsHook
    implements SerializerHook<ThreeBags> {
        @Override
        public Class<ThreeBags> getSerializationType() {
            return ThreeBags.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<ThreeBags>(){

                @Override
                public void write(ObjectDataOutput out, ThreeBags t) throws IOException {
                    out.writeObject(t.bag0());
                    out.writeObject(t.bag1());
                    out.writeObject(t.bag2());
                }

                @Override
                public ThreeBags read(ObjectDataInput in) throws IOException {
                    return ThreeBags.threeBags((Collection)in.readObject(), (Collection)in.readObject(), (Collection)in.readObject());
                }

                @Override
                public int getTypeId() {
                    return -313;
                }

                @Override
                public void destroy() {
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class TwoBagsHook
    implements SerializerHook<TwoBags> {
        @Override
        public Class<TwoBags> getSerializationType() {
            return TwoBags.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<TwoBags>(){

                @Override
                public void write(ObjectDataOutput out, TwoBags t) throws IOException {
                    out.writeObject(t.bag0());
                    out.writeObject(t.bag1());
                }

                @Override
                public TwoBags read(ObjectDataInput in) throws IOException {
                    return TwoBags.twoBags((Collection)in.readObject(), (Collection)in.readObject());
                }

                @Override
                public int getTypeId() {
                    return -312;
                }

                @Override
                public void destroy() {
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class Tuple3Hook
    implements SerializerHook<Tuple3> {
        @Override
        public Class<Tuple3> getSerializationType() {
            return Tuple3.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<Tuple3>(){

                @Override
                public void write(ObjectDataOutput out, Tuple3 t) throws IOException {
                    out.writeObject(t.f0());
                    out.writeObject(t.f1());
                    out.writeObject(t.f2());
                }

                @Override
                public Tuple3 read(ObjectDataInput in) throws IOException {
                    return Tuple3.tuple3(in.readObject(), in.readObject(), in.readObject());
                }

                @Override
                public int getTypeId() {
                    return -311;
                }

                @Override
                public void destroy() {
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class Tuple2Hook
    implements SerializerHook<Tuple2> {
        @Override
        public Class<Tuple2> getSerializationType() {
            return Tuple2.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<Tuple2>(){

                @Override
                public void write(ObjectDataOutput out, Tuple2 t) throws IOException {
                    out.writeObject(t.f0());
                    out.writeObject(t.f1());
                }

                @Override
                public Tuple2 read(ObjectDataInput in) throws IOException {
                    return Tuple2.tuple2(in.readObject(), in.readObject());
                }

                @Override
                public int getTypeId() {
                    return -310;
                }

                @Override
                public void destroy() {
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class WindowResultHook
    implements SerializerHook<WindowResult> {
        @Override
        public Class<WindowResult> getSerializationType() {
            return WindowResult.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<WindowResult>(){

                @Override
                public void write(ObjectDataOutput out, WindowResult object) throws IOException {
                    out.writeObject(object.getKey());
                    out.writeLong(object.getStart());
                    out.writeLong(object.getEnd());
                    out.writeObject(object.getValue());
                }

                @Override
                public WindowResult read(ObjectDataInput in) throws IOException {
                    Object key = in.readObject();
                    long start = in.readLong();
                    long end = in.readLong();
                    Object result = in.readObject();
                    return new WindowResult(start, end, key, result);
                }

                @Override
                public int getTypeId() {
                    return -321;
                }

                @Override
                public void destroy() {
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class TimestampedEntryHook
    implements SerializerHook<TimestampedEntry> {
        @Override
        public Class<TimestampedEntry> getSerializationType() {
            return TimestampedEntry.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<TimestampedEntry>(){

                @Override
                public void write(ObjectDataOutput out, TimestampedEntry object) throws IOException {
                    out.writeLong(object.getTimestamp());
                    out.writeObject(object.getKey());
                    out.writeObject(object.getValue());
                }

                @Override
                public TimestampedEntry read(ObjectDataInput in) throws IOException {
                    long timestamp = in.readLong();
                    Object key = in.readObject();
                    Object value = in.readObject();
                    return new TimestampedEntry(timestamp, key, value);
                }

                @Override
                public int getTypeId() {
                    return -303;
                }

                @Override
                public void destroy() {
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class TimestampedItemHook
    implements SerializerHook<TimestampedItem> {
        @Override
        public Class<TimestampedItem> getSerializationType() {
            return TimestampedItem.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<TimestampedItem>(){

                @Override
                public int getTypeId() {
                    return -325;
                }

                @Override
                public void destroy() {
                }

                @Override
                public void write(ObjectDataOutput out, TimestampedItem timestampedItem) throws IOException {
                    out.writeLong(timestampedItem.timestamp());
                    out.writeObject(timestampedItem.item());
                }

                @Override
                public TimestampedItem read(ObjectDataInput in) throws IOException {
                    long timestamp = in.readLong();
                    Object item = in.readObject();
                    return new TimestampedItem(timestamp, item);
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }
}

