/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.impl.util.Util;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class WindowResult<K, R>
implements Map.Entry<K, R> {
    private final long start;
    private final long end;
    private final K key;
    private final R result;

    public WindowResult(long start, long end, @Nonnull K key, @Nonnull R result) {
        this.start = start;
        this.end = end;
        this.key = key;
        this.result = result;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public R getValue() {
        return this.result;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException("setValue called on the immutable WindowResult");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof WindowResult)) return false;
        WindowResult that = (WindowResult)obj;
        if (this.start != that.start) return false;
        if (this.end != that.end) return false;
        if (!Objects.equals(this.key, that.key)) return false;
        if (!Objects.equals(this.result, that.result)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int hc = 17;
        hc = 73 * hc + Long.hashCode(this.start);
        hc = 73 * hc + Long.hashCode(this.end);
        hc = 73 * hc + Objects.hashCode(this.key);
        hc = 73 * hc + Objects.hashCode(this.result);
        return hc;
    }

    public String toString() {
        return String.format("WindowResult{start=%s, end=%s, key='%s', value='%s'}", Util.toLocalTime(this.start), Util.toLocalTime(this.end), this.key, this.result);
    }
}

