/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.impl.execution.BroadcastEntry;
import com.hazelcast.jet.impl.execution.BroadcastKeyReference;
import com.hazelcast.jet.impl.execution.SnapshotBarrier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

class ExecutionSerializerHooks {
    ExecutionSerializerHooks() {
    }

    public static final class BroadcastKeyReferenceHook
    implements SerializerHook<BroadcastKeyReference> {
        @Override
        public Class<BroadcastKeyReference> getSerializationType() {
            return BroadcastKeyReference.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<BroadcastKeyReference>(){

                @Override
                public int getTypeId() {
                    return -320;
                }

                @Override
                public void destroy() {
                }

                @Override
                public void write(ObjectDataOutput out, BroadcastKeyReference object) throws IOException {
                    out.writeLong(object.id());
                    out.writeObject(object.key());
                }

                @Override
                public BroadcastKeyReference read(ObjectDataInput in) throws IOException {
                    return new BroadcastKeyReference(in.readLong(), in.readObject());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class BroadcastEntryHook
    implements SerializerHook<BroadcastEntry> {
        @Override
        public Class<BroadcastEntry> getSerializationType() {
            return BroadcastEntry.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<BroadcastEntry>(){

                @Override
                public int getTypeId() {
                    return -319;
                }

                @Override
                public void destroy() {
                }

                @Override
                public void write(ObjectDataOutput out, BroadcastEntry object) throws IOException {
                    out.writeObject(object.getKey());
                    out.writeObject(object.getValue());
                }

                @Override
                public BroadcastEntry read(ObjectDataInput in) throws IOException {
                    return new BroadcastEntry(in.readObject(), in.readObject());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class SnapshotBarrierHook
    implements SerializerHook<SnapshotBarrier> {
        @Override
        public Class<SnapshotBarrier> getSerializationType() {
            return SnapshotBarrier.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<SnapshotBarrier>(){

                @Override
                public int getTypeId() {
                    return -318;
                }

                @Override
                public void destroy() {
                }

                @Override
                public void write(ObjectDataOutput out, SnapshotBarrier object) throws IOException {
                    out.writeLong(object.snapshotId());
                }

                @Override
                public SnapshotBarrier read(ObjectDataInput in) throws IOException {
                    return new SnapshotBarrier(in.readLong());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }
}

