/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.Collection;

public class SnapshotRecord
implements IdentifiedDataSerializable {
    private long jobId;
    private long snapshotId;
    private long startTime = System.currentTimeMillis();
    private SnapshotStatus status = SnapshotStatus.ONGOING;
    private Collection<String> vertices;

    public SnapshotRecord() {
    }

    public SnapshotRecord(long jobId, long snapshotId, Collection<String> vertices) {
        this.jobId = jobId;
        this.snapshotId = snapshotId;
        this.vertices = vertices;
    }

    public long jobId() {
        return this.jobId;
    }

    public Collection<String> vertices() {
        return this.vertices;
    }

    public SnapshotStatus status() {
        return this.status;
    }

    public void setStatus(SnapshotStatus newStatus) {
        Preconditions.checkFalse(newStatus == null || newStatus == SnapshotStatus.ONGOING, "new status cannot be null or " + (Object)((Object)SnapshotStatus.ONGOING));
        if (newStatus == SnapshotStatus.SUCCESSFUL || newStatus == SnapshotStatus.FAILED) {
            Preconditions.checkTrue(this.status == SnapshotStatus.ONGOING, "new status can be " + (Object)((Object)newStatus) + " only when current status is " + (Object)((Object)this.status));
        }
        this.status = newStatus;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public long startTime() {
        return this.startTime;
    }

    public boolean isSuccessful() {
        return this.status == SnapshotStatus.SUCCESSFUL;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 11;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeLong(this.snapshotId);
        out.writeLong(this.startTime);
        out.writeUTF(this.status.toString());
        out.writeObject(this.vertices);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.snapshotId = in.readLong();
        this.startTime = in.readLong();
        this.status = SnapshotStatus.valueOf(in.readUTF());
        this.vertices = (Collection)in.readObject();
    }

    public String toString() {
        return "SnapshotRecord{jobId=" + Util.idToString(this.jobId) + ", snapshotId=" + this.snapshotId + ", startTime=" + Util.toLocalDateTime(this.startTime) + ", status=" + (Object)((Object)this.status) + ", vertices=" + this.vertices + '}';
    }

    public static enum SnapshotStatus {
        ONGOING,
        SUCCESSFUL,
        FAILED,
        TO_DELETE;

    }
}

