/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.operation.AbstractJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.ExceptionAction;
import java.io.IOException;

public class CancelExecutionOperation
extends AbstractJobOperation {
    private long executionId;

    public CancelExecutionOperation() {
    }

    public CancelExecutionOperation(long jobId, long executionId) {
        super(jobId);
        this.executionId = executionId;
    }

    @Override
    public void run() throws Exception {
        JetService service = (JetService)this.getService();
        JobExecutionService executionService = service.getJobExecutionService();
        Address callerAddress = this.getCallerAddress();
        ExecutionContext ctx = executionService.assertExecutionContext(callerAddress, this.jobId(), this.executionId, this);
        ctx.cancelExecution();
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isTopologicalFailure(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public int getId() {
        return 21;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
    }
}

