/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.impl.util.Util;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class JetEvent<T> {
    private final T payload;
    private final long timestamp;

    private JetEvent(@Nonnull T payload, long timestamp) {
        this.timestamp = timestamp;
        this.payload = payload;
    }

    public static <T> JetEvent<T> jetEvent(T payload, long timestamp) {
        return new JetEvent<T>(payload, timestamp);
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Nonnull
    public T payload() {
        return this.payload;
    }

    public String toString() {
        return "JetEvent{ts=" + Util.toLocalTime(this.timestamp) + ", payload=" + this.payload + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JetEvent jetEvent = (JetEvent)o;
        return this.timestamp == jetEvent.timestamp && Objects.equals(this.payload, jetEvent.payload);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.timestamp);
    }
}

