/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBiPredicate;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.function.KeyedWindowResultFunction;
import com.hazelcast.jet.function.WindowResultFunction;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.JetEvent;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.Arrays;
import javax.annotation.Nonnull;

class JetEventFunctionAdapter
extends FunctionAdapter {
    JetEventFunctionAdapter() {
    }

    @Nonnull
    DistributedFunction adaptMapFn(@Nonnull DistributedFunction mapFn) {
        return e -> {
            Object result = mapFn.apply(((JetEvent)e).payload());
            return result != null ? JetEvent.jetEvent(result, ((JetEvent)e).timestamp()) : null;
        };
    }

    @Nonnull
    DistributedBiFunction adaptMapUsingContextFn(@Nonnull DistributedBiFunction mapFn) {
        return (context, e) -> {
            Object result = mapFn.apply(context, ((JetEvent)e).payload());
            return result != null ? JetEvent.jetEvent(result, ((JetEvent)e).timestamp()) : null;
        };
    }

    @Nonnull
    DistributedPredicate adaptFilterFn(@Nonnull DistributedPredicate filterFn) {
        return e -> filterFn.test(((JetEvent)e).payload());
    }

    @Nonnull
    DistributedBiPredicate adaptFilterUsingContextFn(@Nonnull DistributedBiPredicate filterFn) {
        return (context, e) -> filterFn.test(context, ((JetEvent)e).payload());
    }

    @Nonnull
    <R, T> DistributedFunction<? super Object, ? extends Traverser<?>> adaptFlatMapFn(@Nonnull DistributedFunction<? super T, ? extends Traverser<? extends R>> flatMapFn) {
        DistributedFunction fn = flatMapFn;
        return e -> ((Traverser)fn.apply((Object)((JetEvent)e).payload())).map(r -> JetEvent.jetEvent(r, ((JetEvent)e).timestamp()));
    }

    @Override
    @Nonnull
    <C, R, T> DistributedBiFunction<? super C, Object, ? extends Traverser<?>> adaptFlatMapUsingContextFn(@Nonnull DistributedBiFunction<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        DistributedBiFunction fn = flatMapFn;
        return (context, e) -> ((Traverser)fn.apply((Object)context, (Object)((JetEvent)e).payload())).map(r -> JetEvent.jetEvent(r, ((JetEvent)e).timestamp()));
    }

    @Nonnull
    DistributedFunction<?, ?> adaptToStringFn(@Nonnull DistributedFunction mapFn) {
        return e -> mapFn.apply(((JetEvent)e).payload());
    }

    @Override
    @Nonnull
    public JoinClause adaptJoinClause(@Nonnull JoinClause joinClause) {
        return JoinClause.onKeys(JetEventFunctionAdapter.adaptKeyFn(joinClause.leftKeyFn()), joinClause.rightKeyFn()).projecting(joinClause.rightProjectFn());
    }

    @Override
    public <T, T1, R> DistributedBiFunction<Object, T1, Object> adaptHashJoinOutputFn(DistributedBiFunction<T, T1, R> mapToOutputFn) {
        return (e, t1) -> {
            JetEvent jetEvent = (JetEvent)e;
            return JetEvent.jetEvent(mapToOutputFn.apply(jetEvent.payload(), t1), jetEvent.timestamp());
        };
    }

    @Override
    <T, T1, T2, R> DistributedTriFunction<Object, T1, T2, Object> adaptHashJoinOutputFn(DistributedTriFunction<T, T1, T2, R> mapToOutputFn) {
        return (e, t1, t2) -> {
            JetEvent jetEvent = (JetEvent)e;
            return JetEvent.jetEvent(mapToOutputFn.apply(jetEvent.payload(), t1, t2), jetEvent.timestamp());
        };
    }

    @Override
    <R, OUT> WindowResultFunction<? super R, JetEvent<OUT>> adaptWindowResultFn(WindowResultFunction<? super R, ? extends OUT> windowResultFn) {
        return (winStart, winEnd, windowResult) -> JetEvent.jetEvent(windowResultFn.apply(winStart, winEnd, windowResult), winEnd);
    }

    @Override
    <K, R, OUT> KeyedWindowResultFunction<? super K, ? super R, JetEvent<OUT>> adaptKeyedWindowResultFn(KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> keyedWindowResultFn) {
        return (winStart, winEnd, key, windowResult) -> JetEvent.jetEvent(keyedWindowResultFn.apply(winStart, winEnd, key, windowResult), winEnd);
    }

    @Nonnull
    static AggregateOperation adaptAggregateOperation(@Nonnull AggregateOperation aggrOp) {
        if (aggrOp instanceof AggregateOperation1) {
            return JetEventFunctionAdapter.adaptAggregateOperation1((AggregateOperation1)aggrOp);
        }
        if (aggrOp instanceof AggregateOperation2) {
            return JetEventFunctionAdapter.adaptAggregateOperation2((AggregateOperation2)aggrOp);
        }
        if (aggrOp instanceof AggregateOperation3) {
            return JetEventFunctionAdapter.adaptAggregateOperation3((AggregateOperation3)aggrOp);
        }
        DistributedBiConsumer[] adaptedAccFns = new DistributedBiConsumer[aggrOp.arity()];
        Arrays.setAll(adaptedAccFns, i -> JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn(i)));
        return aggrOp.withAccumulateFns(adaptedAccFns);
    }

    static <T, A, R> AggregateOperation1<JetEvent<T>, A, R> adaptAggregateOperation1(@Nonnull AggregateOperation1<? super T, A, R> aggrOp) {
        return aggrOp.withAccumulateFn(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn()));
    }

    static <T0, T1, A, R> AggregateOperation2<JetEvent<T0>, JetEvent<T1>, A, R> adaptAggregateOperation2(@Nonnull AggregateOperation2<? super T0, ? super T1, A, R> aggrOp) {
        return aggrOp.withAccumulateFn0(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn0())).withAccumulateFn1(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn1()));
    }

    static <T0, T1, T2, A, R> AggregateOperation3<JetEvent<T0>, JetEvent<T1>, JetEvent<T2>, A, R> adaptAggregateOperation3(@Nonnull AggregateOperation3<? super T0, ? super T1, ? super T2, A, R> aggrOp) {
        return aggrOp.withAccumulateFn0(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn0())).withAccumulateFn1(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn1())).withAccumulateFn2(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn2()));
    }

    @Nonnull
    static <T, K> DistributedFunction<? super JetEvent<T>, ? extends K> adaptKeyFn(@Nonnull DistributedFunction<? super T, ? extends K> keyFn) {
        return e -> keyFn.apply((Object)e.payload());
    }

    @Nonnull
    private static <A, T> DistributedBiConsumer<? super A, ? super JetEvent<T>> adaptAccumulateFn(@Nonnull DistributedBiConsumer<? super A, ? super T> accumulateFn) {
        return (acc, t) -> accumulateFn.accept((Object)acc, (Object)t.payload());
    }
}

