/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.impl.pipeline.JetEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

public class PipelineSerializerHooks {

    public static final class JetEventHook
    implements SerializerHook<JetEvent> {
        @Override
        public Class<JetEvent> getSerializationType() {
            return JetEvent.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<JetEvent>(){

                @Override
                public void write(ObjectDataOutput out, JetEvent object) throws IOException {
                    out.writeObject(object.payload());
                    out.writeLong(object.timestamp());
                }

                @Override
                public JetEvent read(ObjectDataInput in) throws IOException {
                    Object payload = in.readObject();
                    long timestamp = in.readLong();
                    return JetEvent.jetEvent(payload, timestamp);
                }

                @Override
                public int getTypeId() {
                    return -324;
                }

                @Override
                public void destroy() {
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }
}

