/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.jet.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.Map;

public final class MapEntryHook
implements SerializerHook<Map.Entry> {
    @Override
    public Class<Map.Entry> getSerializationType() {
        return Map.Entry.class;
    }

    @Override
    public Serializer createSerializer() {
        return new StreamSerializer<Map.Entry>(){

            @Override
            public int getTypeId() {
                return -300;
            }

            @Override
            public void write(ObjectDataOutput out, Map.Entry object) throws IOException {
                out.writeObject(object.getKey());
                out.writeObject(object.getValue());
            }

            @Override
            public Map.Entry read(ObjectDataInput in) throws IOException {
                return Util.entry(in.readObject(), in.readObject());
            }

            @Override
            public void destroy() {
            }
        };
    }

    @Override
    public boolean isOverwritable() {
        return true;
    }
}

