/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.impl.util.WrappingProcessorSupplier;
import com.hazelcast.nio.Address;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class WrappingProcessorMetaSupplier
implements ProcessorMetaSupplier {
    private ProcessorMetaSupplier wrapped;
    private DistributedFunction<Processor, Processor> wrapperSupplier;

    public WrappingProcessorMetaSupplier(ProcessorMetaSupplier wrapped, DistributedFunction<Processor, Processor> wrapperSupplier) {
        this.wrapped = wrapped;
        this.wrapperSupplier = wrapperSupplier;
    }

    @Override
    public int preferredLocalParallelism() {
        return this.wrapped.preferredLocalParallelism();
    }

    @Override
    @Nonnull
    public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        Function<Address, ProcessorSupplier> function = this.wrapped.get(addresses);
        return address -> new WrappingProcessorSupplier((ProcessorSupplier)function.apply((Address)address), this.wrapperSupplier);
    }

    @Override
    public void init(@Nonnull ProcessorMetaSupplier.Context context) {
        this.wrapped.init(context);
    }

    @Override
    public void close(Throwable error) {
        this.wrapped.close(error);
    }
}

