/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.DiagnosticProcessors;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkBuilder;
import com.hazelcast.map.EntryProcessor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Sinks {
    private Sinks() {
    }

    @Nonnull
    public static <T> Sink<T> fromProcessor(@Nonnull String sinkName, @Nonnull ProcessorMetaSupplier metaSupplier) {
        return new SinkImpl(sinkName, metaSupplier);
    }

    @Nonnull
    public static <T extends Map.Entry> Sink<T> map(@Nonnull String mapName) {
        return Sinks.fromProcessor("mapSink(" + mapName + ')', SinkProcessors.writeMapP(mapName));
    }

    @Nonnull
    public static <T extends Map.Entry> Sink<T> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteMapSink(" + mapName + ')', SinkProcessors.writeRemoteMapP(mapName, clientConfig));
    }

    @Nonnull
    public static <E, K, V> Sink<E> mapWithMerging(@Nonnull String mapName, @Nonnull DistributedFunction<E, K> toKeyFn, @Nonnull DistributedFunction<E, V> toValueFn, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.fromProcessor("mapWithMergingSink(" + mapName + ')', SinkProcessors.mergeMapP(mapName, toKeyFn, toValueFn, mergeFn));
    }

    @Nonnull
    public static <E, K, V> Sink<E> remoteMapWithMerging(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedFunction<E, K> toKeyFn, @Nonnull DistributedFunction<E, V> toValueFn, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.fromProcessor("remoteMapWithMergingSink(" + mapName + ')', SinkProcessors.mergeRemoteMapP(mapName, clientConfig, toKeyFn, toValueFn, mergeFn));
    }

    @Nonnull
    public static <E extends Map.Entry, V> Sink<E> mapWithMerging(@Nonnull String mapName, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.fromProcessor("mapWithMergingSink(" + mapName + ')', SinkProcessors.mergeMapP(mapName, DistributedFunctions.entryKey(), DistributedFunctions.entryValue(), mergeFn));
    }

    @Nonnull
    public static <E extends Map.Entry, V> Sink<E> remoteMapWithMerging(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedBinaryOperator<V> mergeFn) {
        return Sinks.fromProcessor("remoteMapWithMergingSink(" + mapName + ')', SinkProcessors.mergeRemoteMapP(mapName, clientConfig, DistributedFunctions.entryKey(), DistributedFunctions.entryValue(), mergeFn));
    }

    @Nonnull
    public static <E, K, V> Sink<E> mapWithUpdating(@Nonnull String mapName, @Nonnull DistributedFunction<E, K> toKeyFn, @Nonnull DistributedBiFunction<V, E, V> updateFn) {
        return Sinks.fromProcessor("mapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateMapP(mapName, toKeyFn, updateFn));
    }

    @Nonnull
    public static <E, K, V> Sink<E> remoteMapWithUpdating(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedFunction<E, K> toKeyFn, @Nonnull DistributedBiFunction<V, E, V> updateFn) {
        return Sinks.fromProcessor("remoteMapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, toKeyFn, updateFn));
    }

    @Nonnull
    public static <E extends Map.Entry, V> Sink<E> mapWithUpdating(@Nonnull String mapName, @Nonnull DistributedBiFunction<V, E, V> updateFn) {
        return Sinks.fromProcessor("mapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateMapP(mapName, Map.Entry::getKey, updateFn));
    }

    @Nonnull
    public static <E extends Map.Entry, V> Sink<E> remoteMapWithUpdating(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedBiFunction<V, E, V> updateFn) {
        return Sinks.fromProcessor("remoteMapWithUpdatingSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, Map.Entry::getKey, updateFn));
    }

    @Nonnull
    public static <E, K, V> Sink<E> mapWithEntryProcessor(@Nonnull String mapName, @Nonnull DistributedFunction<E, K> toKeyFn, @Nonnull DistributedFunction<E, EntryProcessor<K, V>> toEntryProcessorFn) {
        return Sinks.fromProcessor("mapWithEntryProcessorSink(" + mapName + ')', SinkProcessors.updateMapP(mapName, toKeyFn, toEntryProcessorFn));
    }

    @Nonnull
    public static <E, K, V> Sink<E> remoteMapWithEntryProcessor(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedFunction<E, K> toKeyFn, @Nonnull DistributedFunction<E, EntryProcessor<K, V>> toEntryProcessorFn) {
        return Sinks.fromProcessor("remoteMapWithEntryProcessorSink(" + mapName + ')', SinkProcessors.updateRemoteMapP(mapName, clientConfig, toKeyFn, toEntryProcessorFn));
    }

    @Nonnull
    public static <T extends Map.Entry> Sink<T> cache(@Nonnull String cacheName) {
        return Sinks.fromProcessor("cacheSink(" + cacheName + ')', SinkProcessors.writeCacheP(cacheName));
    }

    @Nonnull
    public static <T extends Map.Entry> Sink<T> remoteCache(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteCacheSink(" + cacheName + ')', SinkProcessors.writeRemoteCacheP(cacheName, clientConfig));
    }

    @Nonnull
    public static <T> Sink<T> list(@Nonnull String listName) {
        return Sinks.fromProcessor("listSink(" + listName + ')', SinkProcessors.writeListP(listName));
    }

    @Nonnull
    public static <T> Sink<T> remoteList(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteListSink(" + listName + ')', SinkProcessors.writeRemoteListP(listName, clientConfig));
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port, @Nonnull DistributedFunction<T, String> toStringFn, @Nonnull Charset charset) {
        return Sinks.fromProcessor("socketSink(" + host + ':' + port + ')', SinkProcessors.writeSocketP(host, port, toStringFn, charset));
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port, @Nonnull DistributedFunction<T, String> toStringFn) {
        return Sinks.socket(host, port, toStringFn, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static <T> Sink<T> socket(@Nonnull String host, int port) {
        return Sinks.socket(host, port, Object::toString);
    }

    @Nonnull
    public static <T> Sink<T> files(@Nonnull String directoryName, @Nonnull DistributedFunction<T, String> toStringFn, @Nonnull Charset charset, boolean append) {
        return Sinks.fromProcessor("filesSink(" + directoryName + ')', SinkProcessors.writeFileP(directoryName, toStringFn, charset, append));
    }

    @Nonnull
    public static <T> Sink<T> files(@Nonnull String directoryName, @Nonnull DistributedFunction<T, String> toStringFn) {
        return Sinks.files(directoryName, toStringFn, StandardCharsets.UTF_8, false);
    }

    @Nonnull
    public static <T> Sink<T> files(@Nonnull String directoryName) {
        return Sinks.files(directoryName, Object::toString, StandardCharsets.UTF_8, false);
    }

    @Nonnull
    public static <T> Sink<T> logger(@Nonnull DistributedFunction<T, String> toStringFn) {
        return Sinks.fromProcessor("loggerSink", DiagnosticProcessors.writeLoggerP(toStringFn));
    }

    @Nonnull
    public static <T> Sink<T> logger() {
        return Sinks.logger(Object::toString);
    }

    @Nonnull
    public static <W, T> SinkBuilder<W, T> builder(@Nonnull DistributedFunction<? super JetInstance, ? extends W> createFn) {
        return new SinkBuilder(createFn);
    }
}

