/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.cache.journal.EventJournalCacheEvent;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.WatermarkGenerationParams;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.impl.pipeline.transform.StreamSourceTransform;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.map.journal.EventJournalMapEvent;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class Sources {
    private static final String GLOB_WILDCARD = "*";

    private Sources() {
    }

    @Nonnull
    public static <T> BatchSource<T> batchFromProcessor(@Nonnull String sourceName, @Nonnull ProcessorMetaSupplier metaSupplier) {
        return new BatchSourceTransform(sourceName, metaSupplier);
    }

    @Nonnull
    public static <T> StreamSource<T> streamFromProcessorWithWatermarks(@Nonnull String sourceName, @Nonnull Function<WatermarkGenerationParams<T>, ProcessorMetaSupplier> metaSupplierFn) {
        return new StreamSourceTransform<T>(sourceName, metaSupplierFn, true);
    }

    @Nonnull
    public static <T> StreamSource<T> streamFromProcessor(@Nonnull String sourceName, @Nonnull ProcessorMetaSupplier metaSupplier) {
        return new StreamSourceTransform(sourceName, w -> metaSupplier, false);
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> map(@Nonnull String mapName) {
        return Sources.batchFromProcessor("mapSource(" + mapName + ')', SourceProcessors.readMapP(mapName));
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> map(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<Map.Entry<K, V>, T> projection) {
        return Sources.batchFromProcessor("mapSource(" + mapName + ')', SourceProcessors.readMapP(mapName, predicate, projection));
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> map(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        return Sources.batchFromProcessor("mapSource(" + mapName + ')', SourceProcessors.readMapP(mapName, predicate, projectionFn));
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> mapJournal(@Nonnull String mapName, @Nonnull DistributedPredicate<EventJournalMapEvent<K, V>> predicateFn, @Nonnull DistributedFunction<EventJournalMapEvent<K, V>, T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.streamFromProcessorWithWatermarks("mapJournalSource(" + mapName + ')', w -> SourceProcessors.streamMapP(mapName, predicateFn, projectionFn, initialPos, w));
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> mapJournal(@Nonnull String mapName, @Nonnull JournalInitialPosition initialPos) {
        return Sources.mapJournal(mapName, Util.mapPutEvents(), Util.mapEventToEntry(), initialPos);
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return Sources.batchFromProcessor("remoteMapSource(" + mapName + ')', SourceProcessors.readRemoteMapP(mapName, clientConfig));
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<Map.Entry<K, V>, T> projection) {
        return Sources.batchFromProcessor("remoteMapSource(" + mapName + ')', SourceProcessors.readRemoteMapP(mapName, clientConfig, predicate, projection));
    }

    @Nonnull
    public static <T, K, V> BatchSource<T> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        return Sources.batchFromProcessor("remoteMapSource(" + mapName + ')', SourceProcessors.readRemoteMapP(mapName, clientConfig, predicate, projectionFn));
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> remoteMapJournal(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedPredicate<EventJournalMapEvent<K, V>> predicateFn, @Nonnull DistributedFunction<EventJournalMapEvent<K, V>, T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.streamFromProcessorWithWatermarks("remoteMapJournalSource(" + mapName + ')', w -> SourceProcessors.streamRemoteMapP(mapName, clientConfig, predicateFn, projectionFn, initialPos, w));
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> remoteMapJournal(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull JournalInitialPosition initialPos) {
        return Sources.remoteMapJournal(mapName, clientConfig, Util.mapPutEvents(), Util.mapEventToEntry(), initialPos);
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> cache(@Nonnull String cacheName) {
        return Sources.batchFromProcessor("cacheSource(" + cacheName + ')', SourceProcessors.readCacheP(cacheName));
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> cacheJournal(@Nonnull String cacheName, @Nonnull DistributedPredicate<EventJournalCacheEvent<K, V>> predicateFn, @Nonnull DistributedFunction<EventJournalCacheEvent<K, V>, T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.streamFromProcessorWithWatermarks("cacheJournalSource(" + cacheName + ')', w -> SourceProcessors.streamCacheP(cacheName, predicateFn, projectionFn, initialPos, w));
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> cacheJournal(@Nonnull String cacheName, @Nonnull JournalInitialPosition initialPos) {
        return Sources.cacheJournal(cacheName, Util.cachePutEvents(), Util.cacheEventToEntry(), initialPos);
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> remoteCache(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return Sources.batchFromProcessor("remoteCacheSource(" + cacheName + ')', SourceProcessors.readRemoteCacheP(cacheName, clientConfig));
    }

    @Nonnull
    public static <T, K, V> StreamSource<T> remoteCacheJournal(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedPredicate<EventJournalCacheEvent<K, V>> predicateFn, @Nonnull DistributedFunction<EventJournalCacheEvent<K, V>, T> projectionFn, @Nonnull JournalInitialPosition initialPos) {
        return Sources.streamFromProcessorWithWatermarks("remoteCacheJournalSource(" + cacheName + ')', w -> SourceProcessors.streamRemoteCacheP(cacheName, clientConfig, predicateFn, projectionFn, initialPos, w));
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> remoteCacheJournal(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nonnull JournalInitialPosition initialPos) {
        return Sources.remoteCacheJournal(cacheName, clientConfig, Util.cachePutEvents(), Util.cacheEventToEntry(), initialPos);
    }

    @Nonnull
    public static <T> BatchSource<T> list(@Nonnull String listName) {
        return Sources.batchFromProcessor("listSource(" + listName + ')', SourceProcessors.readListP(listName));
    }

    @Nonnull
    public static <T> BatchSource<T> remoteList(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return Sources.batchFromProcessor("remoteListSource(" + listName + ')', SourceProcessors.readRemoteListP(listName, clientConfig));
    }

    @Nonnull
    public static StreamSource<String> socket(@Nonnull String host, int port, @Nonnull Charset charset) {
        return Sources.streamFromProcessor("socketSource(" + host + ':' + port + ')', SourceProcessors.streamSocketP(host, port, charset));
    }

    @Nonnull
    public static StreamSource<String> socket(@Nonnull String host, int port) {
        return Sources.socket(host, port, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static <R> BatchSource<R> files(@Nonnull String directory, @Nonnull Charset charset, @Nonnull String glob, @Nonnull DistributedBiFunction<String, String, ? extends R> mapOutputFn) {
        return Sources.batchFromProcessor("filesSource(" + new File(directory, glob) + ')', SourceProcessors.readFilesP(directory, charset, glob, mapOutputFn));
    }

    @Nonnull
    public static BatchSource<String> files(@Nonnull String directory) {
        return Sources.files(directory, StandardCharsets.UTF_8, GLOB_WILDCARD, (file, line) -> line);
    }

    @Nonnull
    public static StreamSource<String> fileWatcher(@Nonnull String watchedDirectory, @Nonnull Charset charset, @Nonnull String glob) {
        return Sources.streamFromProcessor("fileWatcherSource(" + watchedDirectory + '/' + glob + ')', SourceProcessors.streamFilesP(watchedDirectory, charset, glob, (file, line) -> line));
    }

    @Nonnull
    public static StreamSource<String> fileWatcher(@Nonnull String watchedDirectory) {
        return Sources.fileWatcher(watchedDirectory, StandardCharsets.UTF_8, GLOB_WILDCARD);
    }
}

