/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream;

import com.hazelcast.jet.ICacheJet;
import com.hazelcast.jet.IListJet;
import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedComparator;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedToDoubleFunction;
import com.hazelcast.jet.function.DistributedToIntFunction;
import com.hazelcast.jet.function.DistributedToLongFunction;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.DistributedDoubleStream;
import com.hazelcast.jet.stream.DistributedIntStream;
import com.hazelcast.jet.stream.DistributedLongStream;
import com.hazelcast.jet.stream.impl.ICacheDecorator;
import com.hazelcast.jet.stream.impl.IListDecorator;
import com.hazelcast.jet.stream.impl.IMapDecorator;
import com.hazelcast.jet.stream.impl.pipeline.AbstractSourcePipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.reducers.CollectorReducer;
import com.hazelcast.query.Predicate;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public interface DistributedStream<T>
extends Stream<T> {
    public static <T> DistributedStream<T> fromSource(JetInstance instance, final BatchSource<T> source, final boolean isOrdered) {
        return new AbstractSourcePipe<T>(new StreamContext(instance)){

            @Override
            protected ProcessorMetaSupplier getSourceMetaSupplier() {
                return ((BatchSourceTransform)source).metaSupplier;
            }

            @Override
            protected String getName() {
                return source.name();
            }

            @Override
            public boolean isOrdered() {
                return isOrdered;
            }
        };
    }

    @Nonnull
    public static <K, V> DistributedStream<Map.Entry<K, V>> fromMap(@Nonnull IMapJet<K, V> map) {
        IMapDecorator decorator = (IMapDecorator)map;
        return DistributedStream.fromSource(decorator.getInstance(), Sources.map(map.getName()), false);
    }

    @Nonnull
    public static <K, V, T> DistributedStream<T> fromMap(@Nonnull IMapJet<K, V> map, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        IMapDecorator decorator = (IMapDecorator)map;
        return DistributedStream.fromSource(decorator.getInstance(), Sources.map(map.getName(), predicate, projectionFn), false);
    }

    @Nonnull
    public static <T> DistributedStream<T> fromList(IListJet<T> list) {
        IListDecorator decorator = (IListDecorator)list;
        return DistributedStream.fromSource(decorator.getInstance(), Sources.list(list.getName()), true);
    }

    @Override
    default public DistributedStream<T> filter(DistributedPredicate<? super T> predicate) {
        return this.filter((java.util.function.Predicate)predicate);
    }

    @Override
    default public <R> DistributedStream<R> map(DistributedFunction<? super T, ? extends R> mapper) {
        return this.map((Function)mapper);
    }

    default public DistributedIntStream mapToInt(DistributedToIntFunction<? super T> mapper) {
        return this.mapToInt((ToIntFunction)mapper);
    }

    default public DistributedLongStream mapToLong(DistributedToLongFunction<? super T> mapper) {
        return this.mapToLong((ToLongFunction)mapper);
    }

    default public DistributedDoubleStream mapToDouble(DistributedToDoubleFunction<? super T> mapper) {
        return this.mapToDouble((ToDoubleFunction)mapper);
    }

    @Override
    default public <R> DistributedStream<R> flatMap(DistributedFunction<? super T, ? extends Stream<? extends R>> mapper) {
        return this.flatMap((Function)mapper);
    }

    default public DistributedIntStream flatMapToInt(DistributedFunction<? super T, ? extends IntStream> mapper) {
        return this.flatMapToInt((Function)mapper);
    }

    default public DistributedLongStream flatMapToLong(DistributedFunction<? super T, ? extends LongStream> mapper) {
        return this.flatMapToLong((Function)mapper);
    }

    default public DistributedDoubleStream flatMapToDouble(DistributedFunction<? super T, ? extends DoubleStream> mapper) {
        return this.flatMapToDouble((Function)mapper);
    }

    @Override
    public DistributedStream<T> distinct();

    @Override
    public DistributedStream<T> sorted();

    @Override
    default public DistributedStream<T> sorted(DistributedComparator<? super T> comparator) {
        return this.sorted((Comparator)comparator);
    }

    @Override
    default public DistributedStream<T> peek(DistributedConsumer<? super T> action) {
        return this.peek((Consumer)action);
    }

    @Override
    public DistributedStream<T> limit(long var1);

    @Override
    public DistributedStream<T> skip(long var1);

    @Override
    default public T reduce(T identity, DistributedBinaryOperator<T> accumulator) {
        return this.reduce(identity, (BinaryOperator<T>)accumulator);
    }

    @Override
    default public Optional<T> reduce(DistributedBinaryOperator<T> accumulator) {
        return this.reduce((BinaryOperator<T>)accumulator);
    }

    @Override
    default public <U> U reduce(U identity, DistributedBiFunction<U, ? super T, U> accumulator, DistributedBinaryOperator<U> combiner) {
        return this.reduce(identity, (BiFunction<U, ? super T, U>)accumulator, (BinaryOperator<U>)combiner);
    }

    @Override
    default public <R> R collect(DistributedSupplier<R> supplier, DistributedBiConsumer<R, ? super T> accumulator, DistributedBiConsumer<R, R> combiner) {
        return this.collect((Supplier<R>)supplier, (BiConsumer<R, ? super T>)accumulator, (BiConsumer<R, R>)combiner);
    }

    @Override
    default public <R, A> R collect(DistributedCollector<? super T, A, R> collector) {
        return this.collect(new CollectorReducer(collector.supplier(), collector.accumulator(), collector.combiner(), collector.finisher()));
    }

    public <R> R collect(DistributedCollector.Reducer<? super T, R> var1);

    @Override
    default public Optional<T> min(DistributedComparator<? super T> comparator) {
        return this.min((Comparator<? super T>)comparator);
    }

    @Override
    default public Optional<T> max(DistributedComparator<? super T> comparator) {
        return this.max((Comparator<? super T>)comparator);
    }

    @Override
    default public boolean anyMatch(DistributedPredicate<? super T> predicate) {
        return this.anyMatch((java.util.function.Predicate<? super T>)predicate);
    }

    @Override
    default public boolean allMatch(DistributedPredicate<? super T> predicate) {
        return this.allMatch((java.util.function.Predicate<? super T>)predicate);
    }

    @Override
    default public boolean noneMatch(DistributedPredicate<? super T> predicate) {
        return this.noneMatch((java.util.function.Predicate<? super T>)predicate);
    }

    @Override
    public DistributedStream<T> sequential();

    @Override
    public DistributedStream<T> parallel();

    @Override
    public DistributedStream<T> unordered();

    @Override
    public DistributedStream<T> filter(java.util.function.Predicate<? super T> var1);

    @Override
    public <R> DistributedStream<R> map(Function<? super T, ? extends R> var1);

    @Override
    public DistributedIntStream mapToInt(ToIntFunction<? super T> var1);

    @Override
    public DistributedLongStream mapToLong(ToLongFunction<? super T> var1);

    @Override
    public DistributedDoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    @Override
    public <R> DistributedStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    @Override
    public DistributedIntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    @Override
    public DistributedLongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    @Override
    public DistributedDoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    @Override
    public DistributedStream<T> sorted(Comparator<? super T> var1);

    @Override
    public DistributedStream<T> peek(Consumer<? super T> var1);

    @Override
    public T reduce(T var1, BinaryOperator<T> var2);

    @Override
    public Optional<T> reduce(BinaryOperator<T> var1);

    @Override
    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    @Override
    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    @Override
    public Optional<T> min(Comparator<? super T> var1);

    @Override
    public Optional<T> max(Comparator<? super T> var1);

    @Override
    public boolean anyMatch(java.util.function.Predicate<? super T> var1);

    @Override
    public boolean allMatch(java.util.function.Predicate<? super T> var1);

    @Override
    public boolean noneMatch(java.util.function.Predicate<? super T> var1);

    public DistributedStream<T> configure(JobConfig var1);

    public static final class Cache {
        private Cache() {
        }

        @Nonnull
        public static <K, V> DistributedStream<Map.Entry<K, V>> fromCache(@Nonnull ICacheJet<K, V> cache) {
            ICacheDecorator decorator = (ICacheDecorator)cache;
            return DistributedStream.fromSource(decorator.getInstance(), Sources.cache(cache.getName()), false);
        }
    }
}

