/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.merge;

import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.partition.IPartitionService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class AbstractSplitBrainHandlerService<Store>
implements SplitBrainHandlerService {
    private final int partitionCount;
    private final NodeEngine nodeEngine;
    private final IPartitionService partitionService;

    protected AbstractSplitBrainHandlerService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.partitionService = nodeEngine.getPartitionService();
        this.partitionCount = this.partitionService.getPartitionCount();
    }

    @Override
    public final Runnable prepareMergeRunnable() {
        this.onPrepareMergeRunnableStart();
        HashMap<String, Collection<Store>> collectedStores = new HashMap<String, Collection<Store>>();
        HashMap<String, Collection<Store>> collectedStoresWithLegacyPolicies = new HashMap<String, Collection<Store>>();
        LinkedList<Store> backupStores = new LinkedList<Store>();
        LinkedList<String> mergingDataStructureNames = new LinkedList<String>();
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            boolean partitionOwner = this.partitionService.isPartitionOwner(partitionId);
            Collection<Iterator<Store>> iterators = this.iteratorsOf(partitionId);
            for (Iterator<Store> iterator : iterators) {
                while (iterator.hasNext()) {
                    Store store = iterator.next();
                    if (partitionOwner) {
                        String dataStructureName = this.getDataStructureName(store);
                        Object mergePolicy = this.getMergePolicy(dataStructureName);
                        if (!this.isDiscardPolicy(mergePolicy)) {
                            if (mergePolicy instanceof SplitBrainMergePolicy) {
                                this.copyToCollectedStores(store, collectedStores);
                            } else {
                                this.copyToCollectedStores(store, collectedStoresWithLegacyPolicies);
                            }
                            mergingDataStructureNames.add(dataStructureName);
                        }
                    } else {
                        backupStores.add(store);
                    }
                    iterator.remove();
                }
            }
        }
        this.onPrepareMergeRunnableEnd(mergingDataStructureNames);
        return this.newMergeRunnable(collectedStores, collectedStoresWithLegacyPolicies, backupStores, this.nodeEngine);
    }

    protected void onPrepareMergeRunnableStart() {
    }

    protected void onPrepareMergeRunnableEnd(Collection<String> dataStructureNames) {
    }

    protected boolean isDiscardPolicy(Object mergePolicy) {
        return mergePolicy instanceof DiscardMergePolicy;
    }

    public void destroyStores(Collection<Store> recordStores) {
        Iterator<Store> iterator = recordStores.iterator();
        while (iterator.hasNext()) {
            try {
                this.destroyStore(iterator.next());
            }
            finally {
                iterator.remove();
            }
        }
    }

    private void copyToCollectedStores(Store store, Map<String, Collection<Store>> collectedStores) {
        String dataStructureName = this.getDataStructureName(store);
        Collection<Store> stores = collectedStores.get(dataStructureName);
        if (stores == null) {
            stores = new LinkedList<Store>();
            collectedStores.put(dataStructureName, stores);
        }
        stores.add(store);
    }

    protected abstract void destroyStore(Store var1);

    protected abstract String getDataStructureName(Store var1);

    protected abstract Object getMergePolicy(String var1);

    protected abstract Collection<Iterator<Store>> iteratorsOf(int var1);

    protected abstract Runnable newMergeRunnable(Map<String, Collection<Store>> var1, Map<String, Collection<Store>> var2, Collection<Store> var3, NodeEngine var4);
}

