/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import javax.annotation.Nonnull;

public class SnapshotValidationRecord
implements IdentifiedDataSerializable {
    public static final SnapshotValidationKey KEY = SnapshotValidationKey.KEY;
    private long snapshotId;
    private long numChunks;
    private long numBytes;
    private long creationTime;
    private long jobId;
    private String jobName;
    private String dagJsonString;

    public SnapshotValidationRecord() {
    }

    SnapshotValidationRecord(long snapshotId, long numChunks, long numBytes, long creationTime, long jobId, @Nonnull String jobName, @Nonnull String dagJsonString) {
        this.snapshotId = snapshotId;
        this.numChunks = numChunks;
        this.numBytes = numBytes;
        this.creationTime = creationTime;
        this.jobId = jobId;
        this.jobName = jobName;
        this.dagJsonString = dagJsonString;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public long numChunks() {
        return this.numChunks;
    }

    public long numBytes() {
        return this.numBytes;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long jobId() {
        return this.jobId;
    }

    public String jobName() {
        return this.jobName;
    }

    public String dagJsonString() {
        return this.dagJsonString;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 35;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.snapshotId);
        out.writeLong(this.numChunks);
        out.writeLong(this.numBytes);
        out.writeLong(this.creationTime);
        out.writeLong(this.jobId);
        out.writeUTF(this.jobName);
        out.writeUTF(this.dagJsonString);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.snapshotId = in.readLong();
        this.numChunks = in.readLong();
        this.numBytes = in.readLong();
        this.creationTime = in.readLong();
        this.jobId = in.readLong();
        this.jobName = in.readUTF();
        this.dagJsonString = in.readUTF();
    }

    static enum SnapshotValidationKey {
        KEY;

    }
}

