/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.core.AbstractProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class HashJoinCollectP<K, T, V>
extends AbstractProcessor {
    private static final BiFunction<Object, Object, Object> MERGE_FN = (o, n) -> {
        if (o instanceof HashJoinArrayList) {
            ((HashJoinArrayList)o).add(n);
            return o;
        }
        HashJoinArrayList res = new HashJoinArrayList();
        res.add(o);
        res.add(n);
        return res;
    };
    private final Map<K, Object> lookupTable = new HashMap<K, Object>();
    @Nonnull
    private final Function<T, K> keyFn;
    @Nonnull
    private final Function<T, V> projectFn;

    public HashJoinCollectP(@Nonnull Function<T, K> keyFn, @Nonnull Function<T, V> projectFn) {
        this.keyFn = keyFn;
        this.projectFn = projectFn;
    }

    @Override
    protected boolean tryProcess0(@Nonnull Object item) {
        Object t = item;
        K key = this.keyFn.apply(t);
        V value = this.projectFn.apply(t);
        this.lookupTable.merge(key, value, MERGE_FN);
        return true;
    }

    @Override
    public boolean complete() {
        return this.tryEmit(this.lookupTable);
    }

    static final class HashJoinArrayList
    extends ArrayList<Object> {
        HashJoinArrayList() {
            super(2);
        }
    }
}

