/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class HashMapHook
implements SerializerHook<HashMap> {
    @Override
    public Class<HashMap> getSerializationType() {
        return HashMap.class;
    }

    @Override
    public Serializer createSerializer() {
        return new StreamSerializer<HashMap>(){

            @Override
            public int getTypeId() {
                return -322;
            }

            @Override
            public void destroy() {
            }

            @Override
            public void write(ObjectDataOutput out, HashMap map) throws IOException {
                out.writeInt(map.size());
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry e = o = iterator.next();
                    out.writeObject(e.getKey());
                    out.writeObject(e.getValue());
                }
            }

            @Override
            public HashMap read(ObjectDataInput in) throws IOException {
                int length = in.readInt();
                HashMap map = new HashMap();
                for (int i = 0; i < length; ++i) {
                    map.put(in.readObject(), in.readObject());
                }
                return map;
            }
        };
    }

    @Override
    public boolean isOverwritable() {
        return true;
    }
}

