/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.util.QuickMath;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

class MetricsDictionary {
    private static final int INITIAL_CAPACITY = 512;
    private String[] dictionary;
    private int size;
    private TreeMap<String, Word> orderedDictionary = new TreeMap(Comparator.naturalOrder());

    MetricsDictionary() {
        this.dictionary = new String[512];
    }

    int getDictionaryId(String word) {
        Objects.requireNonNull(word);
        Word wordObj = this.orderedDictionary.get(word);
        if (wordObj != null) {
            return wordObj.id;
        }
        int nextIdx = this.size++;
        this.orderedDictionary.put(word, new Word(word, nextIdx));
        this.ensureCapacity(nextIdx);
        this.dictionary[nextIdx] = word;
        return nextIdx;
    }

    @Nullable
    String get(int dictionaryId) {
        if (dictionaryId < 0 || dictionaryId > this.size) {
            return null;
        }
        return this.dictionary[dictionaryId];
    }

    int size() {
        return this.size;
    }

    public Collection<Word> words() {
        return this.orderedDictionary.values();
    }

    private void ensureCapacity(int newIndex) {
        if (newIndex < this.dictionary.length - 1) {
            return;
        }
        int newCapacity = QuickMath.nextPowerOfTwo(this.dictionary.length + 1);
        String[] newDictionary = new String[newCapacity];
        System.arraycopy(this.dictionary, 0, newDictionary, 0, this.dictionary.length);
        this.dictionary = newDictionary;
    }

    static final class Word {
        private String word;
        private int id;

        private Word(String word, int id) {
            this.word = word;
            this.id = id;
        }

        String word() {
            return this.word;
        }

        int dictionaryId() {
            return this.id;
        }

        public String toString() {
            return "Word{word='" + this.word + '\'' + ", id=" + this.id + '}';
        }
    }
}

