/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestProcessorContext;
import com.hazelcast.jet.core.test.TestProcessorMetaSupplierContext;
import com.hazelcast.logging.ILogger;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class TestProcessorSupplierContext
extends TestProcessorMetaSupplierContext
implements ProcessorSupplier.Context {
    private int memberIndex;
    private ManagedContext managedContext = object -> object;
    private final Map<String, File> attached = new HashMap<String, File>();

    @Override
    @Nonnull
    public TestProcessorSupplierContext setLogger(@Nonnull ILogger logger) {
        return (TestProcessorContext)super.setLogger(logger);
    }

    @Override
    @Nonnull
    public TestProcessorSupplierContext setJetInstance(@Nonnull JetInstance jetInstance) {
        return (TestProcessorSupplierContext)super.setJetInstance(jetInstance);
    }

    @Override
    @Nonnull
    public TestProcessorSupplierContext setVertexName(@Nonnull String vertexName) {
        return (TestProcessorSupplierContext)super.setVertexName(vertexName);
    }

    @Override
    @Nonnull
    public TestProcessorSupplierContext setTotalParallelism(int totalParallelism) {
        return (TestProcessorSupplierContext)super.setTotalParallelism(totalParallelism);
    }

    @Override
    @Nonnull
    public TestProcessorSupplierContext setLocalParallelism(int localParallelism) {
        return (TestProcessorSupplierContext)super.setLocalParallelism(localParallelism);
    }

    @Override
    @Nonnull
    public TestProcessorSupplierContext setProcessingGuarantee(@Nonnull ProcessingGuarantee processingGuarantee) {
        return (TestProcessorSupplierContext)super.setProcessingGuarantee(processingGuarantee);
    }

    @Override
    public int memberIndex() {
        assert (this.memberIndex >= 0 && this.memberIndex < this.memberCount()) : "memberIndex should be in range 0.." + (this.memberCount() - 1);
        return this.memberIndex;
    }

    @Override
    @Nonnull
    public File attachedDirectory(@Nonnull String id) {
        return this.attachedFile(id);
    }

    @Override
    @Nonnull
    public File attachedFile(@Nonnull String id) {
        File file = this.attached.get(id);
        if (file == null) {
            throw new IllegalArgumentException("File '" + id + "' was not found");
        }
        return file;
    }

    @Override
    @Nonnull
    public ManagedContext managedContext() {
        return this.managedContext;
    }

    @Nonnull
    public TestProcessorSupplierContext addFile(@Nonnull String id, @Nonnull File file) {
        this.attached.put(id, file);
        return this;
    }

    @Nonnull
    public TestProcessorSupplierContext setMemberIndex(int memberIndex) {
        this.memberIndex = memberIndex;
        return this;
    }

    @Nonnull
    public TestProcessorSupplierContext setManagedContext(@Nonnull ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    @Override
    protected String loggerName() {
        return this.vertexName() + "#PS";
    }
}

