/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.core.metrics.JobMetrics;
import com.hazelcast.jet.impl.AbstractJobProxy;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JobMetricsUtil;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.client.protocol.codec.JetExportSnapshotCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetGetJobConfigCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetGetJobMetricsCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetGetJobStatusCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetGetJobSubmissionTimeCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetJoinSubmittedJobCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetResumeJobCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetSubmitJobCodec;
import com.hazelcast.jet.impl.client.protocol.codec.JetTerminateJobCodec;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nonnull;

public class ClientJobProxy
extends AbstractJobProxy<JetClientInstanceImpl> {
    private static final long RETRY_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    private static final long RETRY_TIME_NS = TimeUnit.SECONDS.toNanos(60L);

    ClientJobProxy(JetClientInstanceImpl client, long jobId) {
        super(client, jobId);
    }

    ClientJobProxy(JetClientInstanceImpl client, long jobId, DAG dag, JobConfig config) {
        super(client, jobId, dag, config);
    }

    @Override
    @Nonnull
    public JobStatus getStatus() {
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobStatusCodec.encodeRequest(this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterUuid()).invoke().get();
            JetGetJobStatusCodec.ResponseParameters parameters = JetGetJobStatusCodec.decodeResponse(response);
            return JobStatus.values()[parameters.response];
        });
    }

    @Override
    @Nonnull
    public JobMetrics getMetrics() {
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobMetricsCodec.encodeRequest(this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterUuid()).invoke().get();
            JetGetJobMetricsCodec.ResponseParameters parameters = JetGetJobMetricsCodec.decodeResponse(response);
            return JobMetricsUtil.toJobMetrics((List)this.serializationService().toObject(parameters.response));
        });
    }

    @Override
    protected CompletableFuture<Void> invokeSubmitJob(Data dag, JobConfig config) {
        Object configData = this.serializationService().toData(config);
        ClientMessage request = JetSubmitJobCodec.encodeRequest(this.getId(), dag, configData);
        return this.invocation(request, this.masterUuid()).invoke().thenApply(c -> null);
    }

    @Override
    protected CompletableFuture<Void> invokeJoinJob() {
        ClientMessage request = JetJoinSubmittedJobCodec.encodeRequest(this.getId());
        ClientInvocation invocation = this.invocation(request, this.masterUuid());
        invocation.setInvocationTimeoutMillis(Long.MAX_VALUE);
        return invocation.invoke().thenApply(c -> null);
    }

    @Override
    protected CompletableFuture<Void> invokeTerminateJob(TerminationMode mode) {
        ClientMessage request = JetTerminateJobCodec.encodeRequest(this.getId(), mode.ordinal());
        return this.invocation(request, this.masterUuid()).invoke().thenApply(c -> null);
    }

    @Override
    public void resume() {
        ClientMessage request = JetResumeJobCodec.encodeRequest(this.getId());
        try {
            this.invocation(request, this.masterUuid()).invoke().get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public JobStateSnapshot cancelAndExportSnapshot(String name) {
        return this.doExportSnapshot(name, true);
    }

    @Override
    public JobStateSnapshot exportSnapshot(String name) {
        return this.doExportSnapshot(name, false);
    }

    private JobStateSnapshot doExportSnapshot(String name, boolean cancelJob) {
        ClientMessage request = JetExportSnapshotCodec.encodeRequest(this.getId(), name, cancelJob);
        try {
            this.invocation(request, this.masterUuid()).invoke().get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return ((JetClientInstanceImpl)this.container()).getJobStateSnapshot(name);
    }

    @Override
    protected long doGetJobSubmissionTime() {
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobSubmissionTimeCodec.encodeRequest(this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterUuid()).invoke().get();
            return JetGetJobSubmissionTimeCodec.decodeResponse((ClientMessage)response).response;
        });
    }

    @Override
    protected JobConfig doGetJobConfig() {
        return this.callAndRetryIfTargetNotFound(() -> {
            ClientMessage request = JetGetJobConfigCodec.encodeRequest(this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterUuid()).invoke().get();
            Data data = JetGetJobConfigCodec.decodeResponse((ClientMessage)response).response;
            return (JobConfig)this.serializationService().toObject(data);
        });
    }

    @Override
    protected UUID masterUuid() {
        return ((JetClientInstanceImpl)this.container()).getHazelcastClient().getClientClusterService().getMasterMember().getUuid();
    }

    @Override
    protected SerializationService serializationService() {
        return ((JetClientInstanceImpl)this.container()).getHazelcastClient().getSerializationService();
    }

    @Override
    protected LoggingService loggingService() {
        return ((JetClientInstanceImpl)this.container()).getHazelcastClient().getLoggingService();
    }

    private ClientInvocation invocation(ClientMessage request, UUID invocationUuid) {
        return new ClientInvocation(((JetClientInstanceImpl)this.container()).getHazelcastClient(), request, (Object)("jobId=" + this.getIdString()), invocationUuid);
    }

    private <T> T callAndRetryIfTargetNotFound(Callable<T> action) {
        long timeLimit = System.nanoTime() + RETRY_TIME_NS;
        while (true) {
            try {
                return action.call();
            }
            catch (Exception e) {
                if (System.nanoTime() < timeLimit && e instanceof ExecutionException && e.getCause() instanceof TargetNotMemberException) {
                    LockSupport.parkNanos(RETRY_DELAY_NS);
                    continue;
                }
                throw ExceptionUtil.rethrow(e);
            }
            break;
        }
    }
}

