/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class DelegatingCompletableFuture<V>
extends InternalCompletableFuture<V> {
    protected static final Object VOID = new Object(){

        public String toString() {
            return "void";
        }
    };
    private static final AtomicReferenceFieldUpdater<DelegatingCompletableFuture, Object> DESERIALIZED_VALUE = AtomicReferenceFieldUpdater.newUpdater(DelegatingCompletableFuture.class, Object.class, "deserializedValue");
    protected final CompletableFuture future;
    protected final InternalSerializationService serializationService;
    protected final Object result;
    protected volatile Object deserializedValue = VOID;

    public DelegatingCompletableFuture(@Nonnull SerializationService serializationService, @Nonnull CompletableFuture future) {
        this(serializationService, future, null);
    }

    public DelegatingCompletableFuture(@Nonnull SerializationService serializationService, @Nonnull CompletableFuture future, V result) {
        this.future = future;
        this.serializationService = (InternalSerializationService)serializationService;
        this.result = result;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.resolve(this.future.get());
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.resolve(this.future.get(timeout, unit));
    }

    @Override
    public V getNow(V valueIfAbsent) {
        if (this.result != null) {
            return (V)this.result;
        }
        if (this.deserializedValue != VOID) {
            return (V)this.deserializedValue;
        }
        V value = this.future.getNow(valueIfAbsent);
        return (V)(value instanceof Data ? this.serializationService.toObject(value) : value);
    }

    @Override
    public V join() {
        return this.resolve(this.future.join());
    }

    @Override
    public V joinInternal() {
        if (this.future instanceof InternalCompletableFuture) {
            return this.resolve(((InternalCompletableFuture)this.future).joinInternal());
        }
        try {
            return this.resolve(this.future.join());
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            throw ExceptionUtil.sneakyThrow(AbstractInvocationFuture.wrapOrPeel(cause));
        }
    }

    public Future getDelegate() {
        return this.future;
    }

    protected V resolve(Object object) {
        if (this.result != null) {
            return (V)this.result;
        }
        if (this.deserializedValue != VOID) {
            return (V)this.deserializedValue;
        }
        if (object instanceof Data) {
            Data data = (Data)object;
            object = this.serializationService.toObject(data);
            this.serializationService.disposeData(data);
            object = this.cacheDeserializedValue(object);
        }
        return (V)object;
    }

    protected Object cacheDeserializedValue(Object object) {
        do {
            Object current;
            if ((current = this.deserializedValue) == VOID) continue;
            object = current;
            break;
        } while (!DESERIALIZED_VALUE.compareAndSet(this, VOID, object));
        return object;
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public boolean complete(V value) {
        return this.future.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.future.completeExceptionally(ex);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super V, ? extends U> fn) {
        return this.future.thenApply(new DeserializingFunction<V, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn) {
        return this.future.thenApplyAsync(new DeserializingFunction<V, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super V, ? extends U> fn, Executor executor) {
        return this.future.thenApplyAsync(new DeserializingFunction<V, U>(this.serializationService, fn), executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super V> action) {
        return this.future.thenAccept(new DeserializingConsumer<V>(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action) {
        return this.future.thenAcceptAsync(new DeserializingConsumer<V>(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super V> action, Executor executor) {
        return this.future.thenAcceptAsync(new DeserializingConsumer<V>(this.serializationService, action), executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.future.thenRun(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.future.thenRunAsync(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.future.thenRunAsync(action, executor);
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombine((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(this.serializationService, fn));
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(this.serializationService, fn));
    }

    @Override
    public <U, V1> CompletableFuture<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn, Executor executor) {
        return this.future.thenCombineAsync((CompletionStage)other, new DeserializingBiFunction<V, U, V1>(this.serializationService, fn), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBoth((CompletionStage)other, new DeserializingBiConsumer<V, U>(this.serializationService, action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<V, U>(this.serializationService, action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action, Executor executor) {
        return this.future.thenAcceptBothAsync((CompletionStage)other, new DeserializingBiConsumer<V, U>(this.serializationService, action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBothAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.future.applyToEither(other, new DeserializingFunction<V, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.future.applyToEitherAsync(other, new DeserializingFunction<V, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn, Executor executor) {
        return this.future.applyToEitherAsync(other, new DeserializingFunction<V, U>(this.serializationService, fn), executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.future.acceptEither(other, new DeserializingConsumer<V>(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.future.acceptEitherAsync(other, new DeserializingConsumer<V>(this.serializationService, action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action, Executor executor) {
        return this.future.acceptEitherAsync(other, new DeserializingConsumer<V>(this.serializationService, action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEitherAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenCompose(new DeserializingFunction<V, CompletionStage<U>>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenComposeAsync(new DeserializingFunction<V, CompletionStage<U>>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.future.thenComposeAsync(new DeserializingFunction<V, CompletionStage<U>>(this.serializationService, fn), executor);
    }

    @Override
    public CompletableFuture<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        return new DelegatingCompletableFuture<V>(this.serializationService, (CompletableFuture)this.future.whenComplete(new DeserializingBiConsumer<V, Throwable>(this.serializationService, action)));
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action) {
        return new DelegatingCompletableFuture<V>(this.serializationService, (CompletableFuture)this.future.whenCompleteAsync(new DeserializingBiConsumer<V, Throwable>(this.serializationService, action)));
    }

    @Override
    public CompletableFuture<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action, Executor executor) {
        return new DelegatingCompletableFuture<V>(this.serializationService, (CompletableFuture)this.future.whenCompleteAsync(new DeserializingBiConsumer<V, Throwable>(this.serializationService, action), executor));
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handle(new DeserializingBiFunction<V, Throwable, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handleAsync(new DeserializingBiFunction<V, Throwable, U>(this.serializationService, fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
        return this.future.handleAsync(new DeserializingBiFunction<V, Throwable, U>(this.serializationService, fn), executor);
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<V> exceptionally(Function<Throwable, ? extends V> fn) {
        return new DelegatingCompletableFuture<V>(this.serializationService, (CompletableFuture)this.future.exceptionally(fn));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.future.isCompletedExceptionally();
    }

    @Override
    public void obtrudeValue(V value) {
        this.future.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.future.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.future.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return this.future.toString();
    }

    public V getDeserializedValue() {
        return (V)this.deserializedValue;
    }

    static class DeserializingBiConsumer<T, U>
    implements BiConsumer<T, U> {
        private final SerializationService serializationService;
        private final BiConsumer<T, U> delegate;

        DeserializingBiConsumer(SerializationService serializationService, BiConsumer<T, U> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public void accept(T t, U u) {
            this.delegate.accept(this.serializationService.toObject(t), this.serializationService.toObject(u));
        }
    }

    static class DeserializingBiFunction<T, U, R>
    implements BiFunction<T, U, R> {
        private final SerializationService serializationService;
        private final BiFunction<T, U, R> delegate;

        DeserializingBiFunction(SerializationService serializationService, BiFunction<T, U, R> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public R apply(T t, U u) {
            return this.delegate.apply(this.serializationService.toObject(t), this.serializationService.toObject(u));
        }
    }

    static class DeserializingConsumer<E>
    implements Consumer<E> {
        private final SerializationService serializationService;
        private final Consumer<E> delegate;

        DeserializingConsumer(SerializationService serializationService, Consumer<E> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public void accept(E e) {
            this.delegate.accept(this.serializationService.toObject(e));
        }
    }

    static class DeserializingFunction<E, R>
    implements Function<E, R> {
        private final SerializationService serializationService;
        private final Function<E, R> delegate;

        DeserializingFunction(SerializationService serializationService, Function<E, R> delegate) {
            Objects.requireNonNull(delegate);
            this.serializationService = serializationService;
            this.delegate = delegate;
        }

        @Override
        public R apply(E e) {
            return this.delegate.apply(this.serializationService.toObject(e));
        }
    }
}

