/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class TerminateJobOperation
extends AsyncJobOperation {
    private TerminationMode terminationMode;

    public TerminateJobOperation() {
    }

    public TerminateJobOperation(long jobId, TerminationMode mode) {
        super(jobId);
        this.terminationMode = mode;
    }

    public CompletableFuture<Void> doRun() {
        return this.getJobCoordinationService().terminateJob(this.jobId(), this.terminationMode);
    }

    @Override
    public int getClassId() {
        return 22;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeByte(this.terminationMode.ordinal());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.terminationMode = TerminationMode.values()[in.readByte()];
    }
}

