/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.processor.HashJoinCollectP;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="https://github.com/spotbugs/spotbugs/issues/844")
public class HashJoinP<E0>
extends AbstractProcessor {
    private final List<Function<E0, Object>> keyFns;
    private final List<Map<Object, Object>> lookupTables;
    private final AbstractProcessor.FlatMapper<E0, Object> flatMapper;
    private boolean ordinal0Consumed;

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="https://github.com/spotbugs/spotbugs/issues/844")
    public HashJoinP(@Nonnull List<Function<E0, Object>> keyFns, @Nonnull List<Tag> tags, @Nullable BiFunction mapToOutputBiFn, @Nullable TriFunction mapToOutputTriFn, @Nullable BiFunctionEx<List<Tag>, Object[], ItemsByTag> tupleToItemsByTag) {
        Object mapToOutput;
        BiFunction<Object, Object[], Object> mapTupleToOutputFn;
        this.keyFns = keyFns;
        this.lookupTables = new ArrayList<Object>(Collections.nCopies(keyFns.size(), null));
        Preconditions.checkTrue(mapToOutputBiFn != null ^ mapToOutputTriFn != null, "Exactly one of mapToOutputBiFn and mapToOutputTriFn must be non-null");
        if (!tags.isEmpty()) {
            Objects.requireNonNull(mapToOutputBiFn, "mapToOutputBiFn required with tags");
            mapTupleToOutputFn = (item, tuple) -> {
                ItemsByTag res = (ItemsByTag)tupleToItemsByTag.apply(tags, (Object[])tuple);
                return res == null ? null : mapToOutputBiFn.apply(item, res);
            };
        } else if (keyFns.size() == 1) {
            mapToOutput = Objects.requireNonNull(mapToOutputBiFn, "tags.isEmpty() && keyFns.size() == 1, but mapToOutputBiFn == null");
            mapTupleToOutputFn = (arg_0, arg_1) -> HashJoinP.lambda$new$1((BiFunction)mapToOutput, arg_0, arg_1);
        } else {
            Preconditions.checkTrue(keyFns.size() == 2, "tags.isEmpty(), but keyFns.size() is neither 1 nor 2");
            mapToOutput = Objects.requireNonNull(mapToOutputTriFn, "tags.isEmpty() && keyFns.size() == 2, but mapToOutputTriFn == null");
            mapTupleToOutputFn = (arg_0, arg_1) -> HashJoinP.lambda$new$2((TriFunction)mapToOutput, arg_0, arg_1);
        }
        CombinationsTraverser<Object> traverser = new CombinationsTraverser<Object>(keyFns.size(), mapTupleToOutputFn);
        this.flatMapper = this.flatMapper(traverser::accept);
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        assert (!this.ordinal0Consumed) : "Edge 0 must have a lower priority than all other edges";
        this.lookupTables.set(ordinal - 1, (Map)item);
        return true;
    }

    @Override
    protected boolean tryProcess0(@Nonnull Object item) {
        this.ordinal0Consumed = true;
        return this.flatMapper.tryProcess(item);
    }

    @Nonnull
    private Object lookUpJoined(int index, E0 item) {
        Map<Object, Object> lookupTableForOrdinal = this.lookupTables.get(index);
        Object key = this.keyFns.get(index).apply(item);
        return lookupTableForOrdinal.get(key);
    }

    private static /* synthetic */ Object lambda$new$2(TriFunction mapToOutput, Object item, Object[] tuple) {
        return mapToOutput.apply(item, tuple[0], tuple[1]);
    }

    private static /* synthetic */ Object lambda$new$1(BiFunction mapToOutput, Object item, Object[] tuple) {
        return mapToOutput.apply(item, tuple[0]);
    }

    private class CombinationsTraverser<OUT>
    implements Traverser<OUT> {
        private final BiFunction<E0, Object[], OUT> mapTupleToOutputFn;
        private final Object[] lookedUpValues;
        private final int[] indices;
        private final int[] sizes;
        private final Object[] tuple;
        private E0 currentItem;

        CombinationsTraverser(int keyCount, BiFunction<E0, Object[], OUT> mapTupleToOutputFn) {
            this.mapTupleToOutputFn = mapTupleToOutputFn;
            this.lookedUpValues = new Object[keyCount];
            this.indices = new int[keyCount];
            this.sizes = new int[keyCount];
            this.tuple = new Object[keyCount];
        }

        CombinationsTraverser<OUT> accept(E0 item) {
            assert (this.currentItem == null) : "currentItem not null";
            for (int i = 0; i < this.lookedUpValues.length; ++i) {
                this.lookedUpValues[i] = HashJoinP.this.lookUpJoined(i, item);
                this.sizes[i] = this.lookedUpValues[i] instanceof HashJoinCollectP.HashJoinArrayList ? ((HashJoinCollectP.HashJoinArrayList)this.lookedUpValues[i]).size() : 1;
            }
            Arrays.fill(this.indices, 0);
            this.currentItem = item;
            return this;
        }

        @Override
        public OUT next() {
            while (this.indices[0] < this.sizes[0]) {
                for (int j = 0; j < this.lookedUpValues.length; ++j) {
                    this.tuple[j] = this.sizes[j] == 1 ? this.lookedUpValues[j] : ((HashJoinCollectP.HashJoinArrayList)this.lookedUpValues[j]).get(this.indices[j]);
                }
                OUT result = this.mapTupleToOutputFn.apply(this.currentItem, this.tuple);
                for (int j = this.indices.length - 1; j >= 0; --j) {
                    int n = j;
                    this.indices[n] = this.indices[n] + 1;
                    if (j == 0 || this.indices[j] < this.sizes[j]) break;
                    this.indices[j] = 0;
                }
                if (result == null) continue;
                return result;
            }
            this.currentItem = null;
            return null;
        }
    }
}

