/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.picocli.groovy;

import com.hazelcast.jet.picocli.CommandLine;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PicocliBaseScript
extends Script {
    public static final String COMMAND_LINE = "commandLine";

    protected abstract Object runScriptBody();

    public Object run() {
        String[] args = this.getScriptArguments();
        CommandLine commandLine = this.getOrCreateCommandLine();
        List<CommandLine> parsedCommands = null;
        try {
            parsedCommands = this.parseScriptArguments(commandLine, args);
        }
        catch (CommandLine.ParameterException pe) {
            return this.handleParameterException(pe, args);
        }
        try {
            for (CommandLine parsed : parsedCommands) {
                if (parsed.isUsageHelpRequested()) {
                    return this.printHelpMessage(parsed, System.out);
                }
                if (!parsed.isVersionHelpRequested()) continue;
                return this.printVersionHelpMessage(parsed);
            }
            this.runRunnableSubcommand(parsedCommands);
            return this.runScriptBody();
        }
        catch (Exception ex) {
            return this.handleExecutionException(commandLine, args, ex);
        }
    }

    public String[] getScriptArguments() {
        return (String[])this.getProperty("args");
    }

    protected CommandLine getOrCreateCommandLine() {
        try {
            CommandLine commandLine = (CommandLine)this.getProperty(COMMAND_LINE);
            if (commandLine == null) {
                commandLine = this.createCommandLine();
                this.getMetaClass().setProperty((Object)this, COMMAND_LINE, (Object)commandLine);
            }
            return commandLine;
        }
        catch (MissingPropertyException mpe) {
            CommandLine commandLine = this.createCommandLine();
            this.setProperty(COMMAND_LINE, commandLine);
            return commandLine;
        }
    }

    public CommandLine createCommandLine() {
        CommandLine commandLine = new CommandLine((Object)this);
        if (commandLine.getCommandName().equals("<main class>")) {
            commandLine.setCommandName(((Object)((Object)this)).getClass().getSimpleName());
        }
        return commandLine;
    }

    public List<CommandLine> parseScriptArguments(CommandLine commandLine, String[] args) {
        return commandLine.parse(args);
    }

    public void runRunnableSubcommand(List<CommandLine> parsedCommands) throws Exception {
        CommandLine deepestSubcommand = parsedCommands.get(parsedCommands.size() - 1);
        Object commandObject = deepestSubcommand.getCommand();
        if (commandObject == this) {
            return;
        }
        if (commandObject instanceof Runnable) {
            ((Runnable)commandObject).run();
        } else if (commandObject instanceof Callable) {
            ((Callable)commandObject).call();
        }
    }

    public void printErrorMessage(String message) {
        System.err.println(message);
    }

    public Object handleParameterException(CommandLine.ParameterException pe, String[] args) {
        this.printErrorMessage(String.format("args: %s%n%s", Arrays.toString(args), pe.getMessage()));
        this.printHelpMessage(pe.getCommandLine());
        return 1;
    }

    public Object handleExecutionException(CommandLine commandLine, String[] args, Exception ex) {
        if (ex instanceof CommandLine.ExecutionException) {
            throw (CommandLine.ExecutionException)ex;
        }
        throw new CommandLine.ExecutionException(commandLine, ex.toString(), ex);
    }

    public Object printHelpMessage(CommandLine commandLine) {
        return this.printHelpMessage(commandLine, System.err);
    }

    public Object printHelpMessage(CommandLine commandLine, PrintStream stream) {
        commandLine.usage(stream);
        return null;
    }

    public Object printVersionHelpMessage(CommandLine commandLine) {
        commandLine.printVersionHelp(System.out);
        return null;
    }
}

