/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import javax.annotation.Nonnull;

public final class ServiceFactories {
    private ServiceFactories() {
    }

    @Nonnull
    public static <K, V> ServiceFactory<?, ReplicatedMap<K, V>> replicatedMapService(@Nonnull String mapName) {
        return ServiceFactories.sharedService(ctx -> ctx.jetInstance().getReplicatedMap(mapName));
    }

    @Nonnull
    public static <K, V> ServiceFactory<?, IMap<K, V>> iMapService(@Nonnull String mapName) {
        return ServiceFactories.sharedService(ctx -> ctx.jetInstance().getMap(mapName));
    }

    @Nonnull
    public static <S> ServiceFactory<?, S> sharedService(@Nonnull FunctionEx<? super ProcessorSupplier.Context, S> createServiceFn) {
        return ServiceFactories.sharedService(createServiceFn, ConsumerEx.noop());
    }

    public static <S> ServiceFactory<?, S> sharedService(@Nonnull FunctionEx<? super ProcessorSupplier.Context, S> createServiceFn, @Nonnull ConsumerEx<S> destroyServiceFn) {
        return ServiceFactory.withCreateContextFn(c -> createServiceFn.apply((ProcessorSupplier.Context)c)).withCreateServiceFn((ctx, c) -> c).withDestroyContextFn(destroyServiceFn);
    }

    @Nonnull
    public static <S> ServiceFactory<?, S> nonSharedService(@Nonnull FunctionEx<? super Processor.Context, ? extends S> createServiceFn) {
        return ServiceFactories.nonSharedService(createServiceFn, ConsumerEx.noop());
    }

    public static <S> ServiceFactory<?, S> nonSharedService(@Nonnull FunctionEx<? super Processor.Context, ? extends S> createServiceFn, @Nonnull ConsumerEx<? super S> destroyServiceFn) {
        return ServiceFactory.withCreateContextFn(c -> null).withCreateServiceFn((ctx, c) -> createServiceFn.apply((Processor.Context)ctx)).withDestroyServiceFn(destroyServiceFn);
    }
}

