/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.StoreAdapter;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.RecordStoreAdapter;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import javax.annotation.Nonnull;

public class IndexingMutationObserver<R extends Record>
implements MutationObserver<R> {
    private final int partitionId;
    private final MapContainer mapContainer;
    private final StoreAdapter storeAdapter;
    private final SerializationService ss;
    private final RecordStore recordStore;

    public IndexingMutationObserver(RecordStore recordStore, SerializationService ss) {
        this.partitionId = recordStore.getPartitionId();
        this.mapContainer = recordStore.getMapContainer();
        this.storeAdapter = new RecordStoreAdapter(recordStore);
        this.recordStore = recordStore;
        this.ss = ss;
    }

    @Override
    public void onPutRecord(@Nonnull Data key, @Nonnull R record, Object oldValue, boolean backup) {
        if (!backup) {
            this.saveIndex(key, (Record)record, oldValue, Index.OperationSource.USER);
        }
    }

    @Override
    public void onReplicationPutRecord(@Nonnull Data key, @Nonnull R record, boolean populateIndex) {
        if (populateIndex) {
            this.saveIndex(key, (Record)record, null, Index.OperationSource.SYSTEM);
        }
    }

    @Override
    public void onUpdateRecord(@Nonnull Data key, @Nonnull R record, Object oldValue, Object newValue, boolean backup) {
        if (!backup) {
            this.saveIndex(key, (Record)record, oldValue, Index.OperationSource.USER);
        }
    }

    @Override
    public void onRemoveRecord(@Nonnull Data key, R record) {
        this.removeIndex(key, (Record)record, Index.OperationSource.USER);
    }

    @Override
    public void onEvictRecord(@Nonnull Data key, @Nonnull R record) {
        this.removeIndex(key, (Record)record, Index.OperationSource.USER);
    }

    @Override
    public void onLoadRecord(@Nonnull Data key, @Nonnull R record, boolean backup) {
        if (!backup) {
            this.saveIndex(key, (Record)record, null, Index.OperationSource.USER);
        }
    }

    @Override
    public void onReset() {
        this.clearGlobalIndexes(false);
    }

    @Override
    public void onClear() {
        this.onReset();
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
        this.clearGlobalIndexes(isDuringShutdown);
        this.clearPartitionedIndexes(true);
    }

    private void clearGlobalIndexes(boolean destroy) {
        Indexes indexes = this.mapContainer.getIndexes(this.partitionId);
        if (indexes.isGlobal()) {
            if (destroy) {
                indexes.destroyIndexes();
            } else if (indexes.haveAtLeastOneIndex()) {
                this.fullScanLocalDataToClear(indexes);
            }
        }
    }

    private void clearPartitionedIndexes(boolean destroy) {
        Indexes indexes = this.mapContainer.getIndexes(this.partitionId);
        if (indexes.isGlobal()) {
            return;
        }
        if (destroy) {
            indexes.destroyIndexes();
        } else {
            indexes.clearAll();
        }
    }

    private void fullScanLocalDataToClear(Indexes indexes) {
        InternalIndex[] indexesSnapshot = indexes.getIndexes();
        this.recordStore.forEach((dataKey, record) -> {
            Object value = Records.getValueOrCachedValue(record, this.ss);
            indexes.removeEntry((Data)dataKey, value, Index.OperationSource.SYSTEM);
        }, false);
        Indexes.markPartitionAsUnindexed(this.partitionId, indexesSnapshot);
    }

    private void saveIndex(Data dataKey, Record record, Object oldValue, Index.OperationSource operationSource) {
        Indexes indexes = this.mapContainer.getIndexes(this.partitionId);
        if (!indexes.haveAtLeastOneIndex()) {
            return;
        }
        QueryableEntry queryableEntry = this.mapContainer.newQueryEntry(this.toBackingKeyFormat(dataKey), Records.getValueOrCachedValue(record, this.ss));
        queryableEntry.setRecord(record);
        queryableEntry.setStoreAdapter(this.storeAdapter);
        indexes.putEntry(queryableEntry, oldValue, operationSource);
    }

    private void removeIndex(Data dataKey, Record record, Index.OperationSource operationSource) {
        Indexes indexes = this.mapContainer.getIndexes(this.partitionId);
        if (!indexes.haveAtLeastOneIndex()) {
            return;
        }
        indexes.removeEntry(this.toBackingKeyFormat(dataKey), Records.getValueOrCachedValue(record, this.ss), operationSource);
    }

    private Data toBackingKeyFormat(Data key) {
        return this.recordStore.getStorage().toBackingDataKeyFormat(key);
    }
}

