/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.client.Client;
import com.hazelcast.client.impl.statistics.ClientStatistics;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.collection.LocalQueueStats;
import com.hazelcast.collection.impl.queue.QueueService;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.cp.CPMember;
import com.hazelcast.durableexecutor.impl.DistributedDurableExecutorService;
import com.hazelcast.executor.impl.DistributedExecutorService;
import com.hazelcast.flakeidgen.impl.FlakeIdGeneratorService;
import com.hazelcast.hotrestart.HotRestartService;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.crdt.pncounter.PNCounterService;
import com.hazelcast.internal.management.TimedMemberState;
import com.hazelcast.internal.management.dto.ClientEndPointDTO;
import com.hazelcast.internal.management.dto.ClusterHotRestartStatusDTO;
import com.hazelcast.internal.monitor.LocalCacheStats;
import com.hazelcast.internal.monitor.LocalFlakeIdGeneratorStats;
import com.hazelcast.internal.monitor.LocalOperationStats;
import com.hazelcast.internal.monitor.LocalPNCounterStats;
import com.hazelcast.internal.monitor.LocalWanStats;
import com.hazelcast.internal.monitor.impl.HotRestartStateImpl;
import com.hazelcast.internal.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.internal.monitor.impl.LocalOperationStatsImpl;
import com.hazelcast.internal.monitor.impl.MemberPartitionStateImpl;
import com.hazelcast.internal.monitor.impl.MemberStateImpl;
import com.hazelcast.internal.monitor.impl.NodeStateImpl;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.multimap.LocalMultiMapStats;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.replicatedmap.LocalReplicatedMapStats;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.scheduledexecutor.impl.DistributedScheduledExecutorService;
import com.hazelcast.topic.LocalTopicStats;
import com.hazelcast.topic.impl.TopicService;
import com.hazelcast.topic.impl.reliable.ReliableTopicService;
import com.hazelcast.wan.impl.WanReplicationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class TimedMemberStateFactory {
    private static final int INITIAL_PARTITION_SAFETY_CHECK_DELAY = 15;
    private static final int PARTITION_SAFETY_CHECK_PERIOD = 60;
    protected final HazelcastInstanceImpl instance;
    private volatile boolean memberStateSafe = true;

    public TimedMemberStateFactory(HazelcastInstanceImpl instance) {
        this.instance = instance;
        if (instance.node.getProperties().get("hazelcast.mc.max.visible.instance.count") != null) {
            instance.node.loggingService.getLogger(this.getClass()).warning("hazelcast.mc.max.visible.instance.count property is removed.");
        }
    }

    public void init() {
        this.instance.node.nodeEngine.getExecutionService().scheduleWithRepetition(() -> {
            this.memberStateSafe = this.instance.getPartitionService().isLocalMemberSafe();
        }, 15L, 60L, TimeUnit.SECONDS);
    }

    @Nonnull
    public TimedMemberState createTimedMemberState() {
        MemberStateImpl memberState = new MemberStateImpl();
        Collection<StatisticsAwareService> services = this.instance.node.nodeEngine.getServices(StatisticsAwareService.class);
        TimedMemberState timedMemberState = new TimedMemberState();
        this.createMemberState(memberState, services);
        timedMemberState.setMaster(this.instance.node.isMaster());
        timedMemberState.setMemberList(new ArrayList<String>());
        Set<Member> memberSet = this.instance.getCluster().getMembers();
        for (Member member : memberSet) {
            MemberImpl memberImpl = (MemberImpl)member;
            Address address = memberImpl.getAddress();
            timedMemberState.getMemberList().add(address.getHost() + ":" + address.getPort());
        }
        timedMemberState.setMemberState(memberState);
        timedMemberState.setClusterName(this.instance.getConfig().getClusterName());
        SSLConfig sslConfig = ConfigAccessor.getActiveMemberNetworkConfig(this.instance.getConfig()).getSSLConfig();
        timedMemberState.setSslEnabled(sslConfig != null && sslConfig.isEnabled());
        timedMemberState.setLite(this.instance.node.isLiteMember());
        SocketInterceptorConfig interceptorConfig = ConfigAccessor.getActiveMemberNetworkConfig(this.instance.getConfig()).getSocketInterceptorConfig();
        timedMemberState.setSocketInterceptorEnabled(interceptorConfig != null && interceptorConfig.isEnabled());
        ManagementCenterConfig managementCenterConfig = this.instance.node.getConfig().getManagementCenterConfig();
        timedMemberState.setScriptingEnabled(managementCenterConfig.isScriptingEnabled());
        return timedMemberState;
    }

    private LocalOperationStats getOperationStats() {
        return new LocalOperationStatsImpl(this.instance.node);
    }

    private void createMemberState(MemberStateImpl memberState, Collection<StatisticsAwareService> services) {
        Node node = this.instance.node;
        Collection<Client> clients = this.instance.node.clientEngine.getClients();
        Set<ClientEndPointDTO> serializableClientEndPoints = SetUtil.createHashSet(clients.size());
        for (Client client : clients) {
            serializableClientEndPoints.add(new ClientEndPointDTO(client));
        }
        memberState.setClients(serializableClientEndPoints);
        memberState.setName(this.instance.getName());
        memberState.setUuid(node.getThisUuid());
        if (this.instance.getConfig().getCPSubsystemConfig().getCPMemberCount() == 0) {
            memberState.setCpMemberUuid(null);
        } else {
            CPMember localCPMember = this.instance.getCPSubsystem().getLocalCPMember();
            memberState.setCpMemberUuid(localCPMember != null ? localCPMember.getUuid() : null);
        }
        Address thisAddress = node.getThisAddress();
        memberState.setAddress(thisAddress.getHost() + ":" + thisAddress.getPort());
        memberState.setEndpoints(node.getLocalMember().getAddressMap());
        MemberPartitionStateImpl memberPartitionState = (MemberPartitionStateImpl)memberState.getMemberPartitionState();
        InternalPartitionService partitionService = node.getPartitionService();
        IPartition[] partitions = partitionService.getPartitions();
        List<Integer> partitionList = memberPartitionState.getPartitions();
        for (IPartition partition : partitions) {
            if (!partition.isLocal()) continue;
            partitionList.add(partition.getPartitionId());
        }
        memberPartitionState.setMemberStateSafe(this.memberStateSafe);
        memberState.setOperationStats(this.getOperationStats());
        this.createMemState(memberState, services);
        this.createNodeState(memberState);
        this.createHotRestartState(memberState);
        this.createClusterHotRestartStatus(memberState);
        memberState.setClientStats(this.getClientAttributes(node.getClientEngine().getClientStatistics()));
    }

    private Map<UUID, String> getClientAttributes(Map<UUID, ClientStatistics> allClientStatistics) {
        Map<UUID, String> statsMap = MapUtil.createHashMap(allClientStatistics.size());
        for (Map.Entry<UUID, ClientStatistics> entry : allClientStatistics.entrySet()) {
            UUID uuid = entry.getKey();
            ClientStatistics statistics = entry.getValue();
            if (statistics == null) continue;
            statsMap.put(uuid, statistics.clientAttributes());
        }
        return statsMap;
    }

    private void createHotRestartState(MemberStateImpl memberState) {
        HotRestartService hotRestartService = this.instance.node.getNodeExtension().getHotRestartService();
        boolean hotBackupEnabled = hotRestartService.isHotBackupEnabled();
        String hotBackupDirectory = hotRestartService.getBackupDirectory();
        HotRestartStateImpl state = new HotRestartStateImpl(hotRestartService.getBackupTaskStatus(), hotBackupEnabled, hotBackupDirectory);
        memberState.setHotRestartState(state);
    }

    private void createClusterHotRestartStatus(MemberStateImpl memberState) {
        ClusterHotRestartStatusDTO state = this.instance.node.getNodeExtension().getInternalHotRestartService().getCurrentClusterHotRestartStatus();
        memberState.setClusterHotRestartStatus(state);
    }

    protected void createNodeState(MemberStateImpl memberState) {
        Node node = this.instance.node;
        ClusterServiceImpl cluster = this.instance.node.clusterService;
        NodeStateImpl nodeState = new NodeStateImpl(cluster.getClusterState(), node.getState(), cluster.getClusterVersion(), node.getVersion());
        memberState.setNodeState(nodeState);
    }

    private void createMemState(MemberStateImpl memberState, Collection<StatisticsAwareService> services) {
        Config config = this.instance.getConfig();
        for (StatisticsAwareService service : services) {
            if (service instanceof MapService) {
                this.handleMap(memberState, ((MapService)service).getStats());
                continue;
            }
            if (service instanceof MultiMapService) {
                this.handleMultiMap(memberState, ((MultiMapService)service).getStats());
                continue;
            }
            if (service instanceof QueueService) {
                this.handleQueue(memberState, ((QueueService)service).getStats());
                continue;
            }
            if (service instanceof TopicService) {
                this.handleTopic(memberState, ((TopicService)service).getStats());
                continue;
            }
            if (service instanceof ReliableTopicService) {
                this.handleReliableTopic(memberState, ((ReliableTopicService)service).getStats());
                continue;
            }
            if (service instanceof DistributedExecutorService) {
                this.handleExecutorService(memberState, config, ((DistributedExecutorService)service).getStats());
                continue;
            }
            if (service instanceof DistributedScheduledExecutorService) {
                this.handleScheduledExecutorService(memberState, config, ((DistributedScheduledExecutorService)service).getStats());
                continue;
            }
            if (service instanceof DistributedDurableExecutorService) {
                this.handleDurableExecutorService(memberState, config, ((DistributedDurableExecutorService)service).getStats());
                continue;
            }
            if (service instanceof ReplicatedMapService) {
                this.handleReplicatedMap(memberState, config, ((ReplicatedMapService)service).getStats());
                continue;
            }
            if (service instanceof PNCounterService) {
                this.handlePNCounter(memberState, config, ((PNCounterService)service).getStats());
                continue;
            }
            if (service instanceof FlakeIdGeneratorService) {
                this.handleFlakeIdGenerator(memberState, config, ((FlakeIdGeneratorService)service).getStats());
                continue;
            }
            if (!(service instanceof CacheService)) continue;
            this.handleCache(memberState, (CacheService)service);
        }
        WanReplicationService wanReplicationService = this.instance.node.nodeEngine.getWanReplicationService();
        Map<String, LocalWanStats> wanStats = wanReplicationService.getStats();
        if (wanStats != null) {
            this.handleWan(memberState, wanStats);
        }
    }

    private void handleFlakeIdGenerator(MemberStateImpl memberState, Config config, Map<String, LocalFlakeIdGeneratorStats> flakeIdStats) {
        Set<String> flakeIdGeneratorsWithStats = SetUtil.createHashSet(flakeIdStats.size());
        for (String name : flakeIdStats.keySet()) {
            if (!config.findFlakeIdGeneratorConfig(name).isStatisticsEnabled()) continue;
            flakeIdGeneratorsWithStats.add(name);
        }
        memberState.setFlakeIdGeneratorsWithStats(flakeIdGeneratorsWithStats);
    }

    private void handleExecutorService(MemberStateImpl memberState, Config config, Map<String, LocalExecutorStatsImpl> executorServices) {
        Set<String> executorsWithStats = SetUtil.createHashSet(executorServices.size());
        for (String name : executorServices.keySet()) {
            if (!config.findExecutorConfig(name).isStatisticsEnabled()) continue;
            executorsWithStats.add(name);
        }
        memberState.setExecutorsWithStats(executorsWithStats);
    }

    private void handleScheduledExecutorService(MemberStateImpl memberState, Config config, Map<String, LocalExecutorStatsImpl> executorServices) {
        Set<String> executorsWithStats = SetUtil.createHashSet(executorServices.size());
        for (String name : executorServices.keySet()) {
            if (!config.findScheduledExecutorConfig(name).isStatisticsEnabled()) continue;
            executorsWithStats.add(name);
        }
        memberState.setScheduledExecutorsWithStats(executorsWithStats);
    }

    private void handleDurableExecutorService(MemberStateImpl memberState, Config config, Map<String, LocalExecutorStatsImpl> executorServices) {
        Set<String> executorsWithStats = SetUtil.createHashSet(executorServices.size());
        for (String name : executorServices.keySet()) {
            if (!config.findDurableExecutorConfig(name).isStatisticsEnabled()) continue;
            executorsWithStats.add(name);
        }
        memberState.setDurableExecutorsWithStats(executorsWithStats);
    }

    private void handleMultiMap(MemberStateImpl memberState, Map<String, LocalMultiMapStats> multiMaps) {
        memberState.setMultiMapsWithStats(multiMaps.keySet());
    }

    private void handleReplicatedMap(MemberStateImpl memberState, Config config, Map<String, LocalReplicatedMapStats> replicatedMaps) {
        Set<String> mapsWithStats = SetUtil.createHashSet(replicatedMaps.size());
        for (String name : replicatedMaps.keySet()) {
            if (!config.findReplicatedMapConfig(name).isStatisticsEnabled()) continue;
            mapsWithStats.add(name);
        }
        memberState.setReplicatedMapsWithStats(mapsWithStats);
    }

    private void handlePNCounter(MemberStateImpl memberState, Config config, Map<String, LocalPNCounterStats> counters) {
        Set<String> countersWithStats = SetUtil.createHashSet(counters.size());
        for (String name : counters.keySet()) {
            if (!config.findPNCounterConfig(name).isStatisticsEnabled()) continue;
            countersWithStats.add(name);
        }
        memberState.setPNCountersWithStats(countersWithStats);
    }

    private void handleReliableTopic(MemberStateImpl memberState, Map<String, LocalTopicStats> topics) {
        memberState.setReliableTopicsWithStats(topics.keySet());
    }

    private void handleTopic(MemberStateImpl memberState, Map<String, LocalTopicStats> topics) {
        memberState.setTopicsWithStats(topics.keySet());
    }

    private void handleQueue(MemberStateImpl memberState, Map<String, LocalQueueStats> queues) {
        memberState.setQueuesWithStats(queues.keySet());
    }

    private void handleMap(MemberStateImpl memberState, Map<String, LocalMapStats> maps) {
        memberState.setMapsWithStats(maps.keySet());
    }

    private void handleCache(MemberStateImpl memberState, CacheService cacheService) {
        Map<String, LocalCacheStats> map = cacheService.getStats();
        Set<String> cachesWithStats = SetUtil.createHashSet(map.size());
        for (String name : map.keySet()) {
            CacheConfig cacheConfig = cacheService.getCacheConfig(name);
            if (cacheConfig == null || !cacheConfig.isStatisticsEnabled()) continue;
            cachesWithStats.add(name);
        }
        memberState.setCachesWithStats(cachesWithStats);
    }

    private void handleWan(MemberStateImpl memberState, Map<String, LocalWanStats> wans) {
        for (Map.Entry<String, LocalWanStats> entry : wans.entrySet()) {
            String schemeName = entry.getKey();
            LocalWanStats stats = entry.getValue();
            memberState.putLocalWanStats(schemeName, stats);
        }
    }
}

