/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.config.AbstractYamlConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.yaml.W3cDomUtil;
import com.hazelcast.internal.config.yaml.YamlDomChecker;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.config.ConfigProvider;
import com.hazelcast.jet.impl.config.JetConfigSections;
import com.hazelcast.jet.impl.config.YamlJetConfigLocator;
import com.hazelcast.jet.impl.config.YamlJetDomConfigProcessor;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import org.w3c.dom.Node;

public class YamlJetConfigBuilder
extends AbstractYamlConfigBuilder {
    private final InputStream in;

    public YamlJetConfigBuilder() {
        this((YamlJetConfigLocator)null);
    }

    public YamlJetConfigBuilder(YamlJetConfigLocator locator) {
        if (locator == null) {
            locator = new YamlJetConfigLocator();
            locator.locateEverywhere();
        }
        this.in = locator.getIn();
    }

    public YamlJetConfigBuilder(InputStream inputStream) {
        Preconditions.checkTrue(inputStream != null, "inputStream can't be null");
        this.in = inputStream;
    }

    @Override
    protected String getConfigRoot() {
        return JetConfigSections.HAZELCAST_JET.name;
    }

    public JetConfig build() {
        return this.build(new JetConfig());
    }

    public JetConfig build(JetConfig config) {
        try {
            this.parseAndBuildConfig(config);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        config.setHazelcastConfig(ConfigProvider.locateAndGetMemberConfig(this.getProperties()));
        return config;
    }

    private void parseAndBuildConfig(JetConfig config) throws Exception {
        YamlMapping yamlRootNode;
        try {
            yamlRootNode = (YamlMapping)YamlLoader.load(this.in);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Invalid YAML configuration", ex);
        }
        finally {
            IOUtil.closeResource(this.in);
        }
        YamlMapping jetRoot = yamlRootNode.childAsMapping(JetConfigSections.HAZELCAST_JET.name);
        if (jetRoot == null) {
            jetRoot = yamlRootNode;
        }
        YamlDomChecker.check(jetRoot);
        Node w3cRootNode = W3cDomUtil.asW3cNode(jetRoot);
        this.replaceVariables(w3cRootNode);
        this.importDocuments(jetRoot);
        new YamlJetDomConfigProcessor(true, config).buildConfig(w3cRootNode);
    }

    public YamlJetConfigBuilder setProperties(@Nullable Properties properties) {
        if (properties == null) {
            properties = System.getProperties();
        }
        this.setPropertiesInternal(properties);
        return this;
    }
}

